@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.ImageBuilderAccessEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointType Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
 * @property vpceId Identifier (ID) of the interface VPC endpoint.
 */
public data class ImageBuilderAccessEndpointArgs(
    public val endpointType: Output<String>,
    public val vpceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.ImageBuilderAccessEndpointArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.ImageBuilderAccessEndpointArgs =
        com.pulumi.aws.appstream.inputs.ImageBuilderAccessEndpointArgs.builder()
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .vpceId(vpceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageBuilderAccessEndpointArgs].
 */
@PulumiTagMarker
public class ImageBuilderAccessEndpointArgsBuilder internal constructor() {
    private var endpointType: Output<String>? = null

    private var vpceId: Output<String>? = null

    /**
     * @param value Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
     */
    @JvmName("tllhlbmpbtwqfxgu")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value Identifier (ID) of the interface VPC endpoint.
     */
    @JvmName("kijmnoasxcthlqle")
    public suspend fun vpceId(`value`: Output<String>) {
        this.vpceId = value
    }

    /**
     * @param value Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
     */
    @JvmName("knhmilwrutpywaye")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Identifier (ID) of the interface VPC endpoint.
     */
    @JvmName("uorpdxqlcefdcypp")
    public suspend fun vpceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpceId = mapped
    }

    internal fun build(): ImageBuilderAccessEndpointArgs = ImageBuilderAccessEndpointArgs(
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        vpceId = vpceId,
    )
}
