@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.ImageBuilderDomainJoinInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property directoryName Fully qualified name of the directory (for example, corp.example.com).
 * @property organizationalUnitDistinguishedName Distinguished name of the organizational unit for computer accounts.
 */
public data class ImageBuilderDomainJoinInfoArgs(
    public val directoryName: Output<String>? = null,
    public val organizationalUnitDistinguishedName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.ImageBuilderDomainJoinInfoArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.ImageBuilderDomainJoinInfoArgs =
        com.pulumi.aws.appstream.inputs.ImageBuilderDomainJoinInfoArgs.builder()
            .directoryName(directoryName?.applyValue({ args0 -> args0 }))
            .organizationalUnitDistinguishedName(
                organizationalUnitDistinguishedName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ImageBuilderDomainJoinInfoArgs].
 */
@PulumiTagMarker
public class ImageBuilderDomainJoinInfoArgsBuilder internal constructor() {
    private var directoryName: Output<String>? = null

    private var organizationalUnitDistinguishedName: Output<String>? = null

    /**
     * @param value Fully qualified name of the directory (for example, corp.example.com).
     */
    @JvmName("bqfsgxabatgyvwsv")
    public suspend fun directoryName(`value`: Output<String>) {
        this.directoryName = value
    }

    /**
     * @param value Distinguished name of the organizational unit for computer accounts.
     */
    @JvmName("djaxvsboxnarnopo")
    public suspend fun organizationalUnitDistinguishedName(`value`: Output<String>) {
        this.organizationalUnitDistinguishedName = value
    }

    /**
     * @param value Fully qualified name of the directory (for example, corp.example.com).
     */
    @JvmName("grbuspbtnsqonfpo")
    public suspend fun directoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryName = mapped
    }

    /**
     * @param value Distinguished name of the organizational unit for computer accounts.
     */
    @JvmName("eiphmycrdcexhhdi")
    public suspend fun organizationalUnitDistinguishedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitDistinguishedName = mapped
    }

    internal fun build(): ImageBuilderDomainJoinInfoArgs = ImageBuilderDomainJoinInfoArgs(
        directoryName = directoryName,
        organizationalUnitDistinguishedName = organizationalUnitDistinguishedName,
    )
}
