@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.StackAccessEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointType Type of the interface endpoint.
 * See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
 * @property vpceId ID of the VPC in which the interface endpoint is used.
 */
public data class StackAccessEndpointArgs(
    public val endpointType: Output<String>,
    public val vpceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.StackAccessEndpointArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.StackAccessEndpointArgs =
        com.pulumi.aws.appstream.inputs.StackAccessEndpointArgs.builder()
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .vpceId(vpceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackAccessEndpointArgs].
 */
@PulumiTagMarker
public class StackAccessEndpointArgsBuilder internal constructor() {
    private var endpointType: Output<String>? = null

    private var vpceId: Output<String>? = null

    /**
     * @param value Type of the interface endpoint.
     * See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
     */
    @JvmName("pvibemtivkoocgbt")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value ID of the VPC in which the interface endpoint is used.
     */
    @JvmName("ejmlgdxficwxgaxi")
    public suspend fun vpceId(`value`: Output<String>) {
        this.vpceId = value
    }

    /**
     * @param value Type of the interface endpoint.
     * See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
     */
    @JvmName("inmksctwphwmdsch")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value ID of the VPC in which the interface endpoint is used.
     */
    @JvmName("gnjlqcsjianqheja")
    public suspend fun vpceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpceId = mapped
    }

    internal fun build(): StackAccessEndpointArgs = StackAccessEndpointArgs(
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        vpceId = vpceId,
    )
}
