@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.StackApplicationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether application settings should be persisted.
 * @property settingsGroup Name of the settings group.
 * Required when `enabled` is `true`.
 * Can be up to 100 characters.
 */
public data class StackApplicationSettingsArgs(
    public val enabled: Output<Boolean>,
    public val settingsGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.StackApplicationSettingsArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.StackApplicationSettingsArgs =
        com.pulumi.aws.appstream.inputs.StackApplicationSettingsArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .settingsGroup(settingsGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackApplicationSettingsArgs].
 */
@PulumiTagMarker
public class StackApplicationSettingsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var settingsGroup: Output<String>? = null

    /**
     * @param value Whether application settings should be persisted.
     */
    @JvmName("bjnibigwceppucil")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of the settings group.
     * Required when `enabled` is `true`.
     * Can be up to 100 characters.
     */
    @JvmName("fdvimusncourcakj")
    public suspend fun settingsGroup(`value`: Output<String>) {
        this.settingsGroup = value
    }

    /**
     * @param value Whether application settings should be persisted.
     */
    @JvmName("ntuiwhvcarabhsjc")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Name of the settings group.
     * Required when `enabled` is `true`.
     * Can be up to 100 characters.
     */
    @JvmName("nioqihefxnurvdaa")
    public suspend fun settingsGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingsGroup = mapped
    }

    internal fun build(): StackApplicationSettingsArgs = StackApplicationSettingsArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        settingsGroup = settingsGroup,
    )
}
