@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountName User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
 * @property accountPassword Password for the account.
 */
public data class DirectoryConfigServiceAccountCredentials(
    public val accountName: String,
    public val accountPassword: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.DirectoryConfigServiceAccountCredentials): DirectoryConfigServiceAccountCredentials = DirectoryConfigServiceAccountCredentials(
            accountName = javaType.accountName(),
            accountPassword = javaType.accountPassword(),
        )
    }
}
