@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property appBlockArn The app block ARN of the application.
 * @property arn Arn of the image being searched for. Cannot be used with name_regex or name.
 * @property createdTime Time at which this image was created.
 * @property description Description of image.
 * @property displayName Image name to display.
 * @property enabled Bool based on if the application is enabled.
 * @property iconS3Locations A list named icon_s3_location that contains the following:
 * @property iconUrl URL of the application icon. This URL may be time-limited.
 * @property instanceFamilies List of the instance families of the application.
 * @property launchParameters Arguments that are passed to the application at it's launch.
 * @property launchPath Path to the application's excecutable in the instance.
 * @property metadata String to string map that contains additional attributes used to describe the application.
 * * `Name` - Name of the application.
 * @property name Name of the image being searched for. Cannot be used with name_regex or arn.
 * @property platforms Array of strings describing the platforms on which the application can run.
 * Values will be from: WINDOWS | WINDOWS_SERVER_2016 | WINDOWS_SERVER_2019 | WINDOWS_SERVER_2022 | AMAZON_LINUX2
 * @property workingDirectory Working directory for the application.
 */
public data class GetImageApplication(
    public val appBlockArn: String,
    public val arn: String,
    public val createdTime: String,
    public val description: String,
    public val displayName: String,
    public val enabled: Boolean,
    public val iconS3Locations: List<GetImageApplicationIconS3Location>,
    public val iconUrl: String,
    public val instanceFamilies: List<String>,
    public val launchParameters: String,
    public val launchPath: String,
    public val metadata: Map<String, String>,
    public val name: String,
    public val platforms: List<String>,
    public val workingDirectory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.GetImageApplication): GetImageApplication = GetImageApplication(
            appBlockArn = javaType.appBlockArn(),
            arn = javaType.arn(),
            createdTime = javaType.createdTime(),
            description = javaType.description(),
            displayName = javaType.displayName(),
            enabled = javaType.enabled(),
            iconS3Locations = javaType.iconS3Locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appstream.kotlin.outputs.GetImageApplicationIconS3Location.Companion.toKotlin(args0)
                })
            }),
            iconUrl = javaType.iconUrl(),
            instanceFamilies = javaType.instanceFamilies().map({ args0 -> args0 }),
            launchParameters = javaType.launchParameters(),
            launchPath = javaType.launchPath(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            platforms = javaType.platforms().map({ args0 -> args0 }),
            workingDirectory = javaType.workingDirectory(),
        )
    }
}
