@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3Bucket S3 bucket of the S3 object.
 * @property s3Key S3 key of the S3 object.
 */
public data class GetImageApplicationIconS3Location(
    public val s3Bucket: String,
    public val s3Key: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.GetImageApplicationIconS3Location): GetImageApplicationIconS3Location = GetImageApplicationIconS3Location(
            s3Bucket = javaType.s3Bucket(),
            s3Key = javaType.s3Key(),
        )
    }
}
