@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property allowFleet Boolean indicating if the image can be used for a fleet.
 * @property allowImageBuilder indicated whether the image can be used for an image builder.
 */
public data class GetImageImagePermission(
    public val allowFleet: Boolean,
    public val allowImageBuilder: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.GetImageImagePermission): GetImageImagePermission = GetImageImagePermission(
            allowFleet = javaType.allowFleet(),
            allowImageBuilder = javaType.allowImageBuilder(),
        )
    }
}
