@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getImage.
 * @property applications
 * @property appstreamAgentVersion Version of the AppStream 2.0 agent to use for instances that are launched from this image. Has a maximum length of 100 characters.
 * @property arn ARN of the image.
 * @property baseImageArn ARN of the image from which the image was created.
 * @property createdTime Time at which this image was created.
 * @property description Description of image.
 * @property displayName Image name to display.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageBuilderName The name of the image builder that was used to created the private image. If the image is sharedthen the value is null.
 * @property imageBuilderSupported Boolean to indicate whether an image builder can be launched from this image.
 * * `image error` - Resource error object that describes the error containing the following:
 * @property imagePermissions List of strings describing the image permissions containing the following:
 * @property mostRecent
 * @property name
 * @property nameRegex
 * @property platform Operating system platform of the image. Values will be from: WINDOWS | WINDOWS_SERVER_2016 | WINDOWS_SERVER_2019 | WINDOWS_SERVER_2022 | AMAZON_LINUX2
 * @property publicBaseImageReleasedDate
 * @property state Current state of image. Image starts in PENDING state which changes to AVAILABLE if creation passes and FAILED if it fails. Values will be from: PENDING | AVAILABLE | FAILED | COPYING | DELETING | CREATING | IMPORTING.
 * @property stateChangeReasons
 * @property type
 */
public data class GetImageResult(
    public val applications: List<GetImageApplication>,
    public val appstreamAgentVersion: String,
    public val arn: String,
    public val baseImageArn: String,
    public val createdTime: String,
    public val description: String,
    public val displayName: String,
    public val id: String,
    public val imageBuilderName: String,
    public val imageBuilderSupported: Boolean,
    public val imagePermissions: List<GetImageImagePermission>,
    public val mostRecent: Boolean? = null,
    public val name: String,
    public val nameRegex: String? = null,
    public val platform: String,
    public val publicBaseImageReleasedDate: String,
    public val state: String,
    public val stateChangeReasons: List<GetImageStateChangeReason>,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.GetImageResult): GetImageResult =
            GetImageResult(
                applications = javaType.applications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appstream.kotlin.outputs.GetImageApplication.Companion.toKotlin(args0)
                    })
                }),
                appstreamAgentVersion = javaType.appstreamAgentVersion(),
                arn = javaType.arn(),
                baseImageArn = javaType.baseImageArn(),
                createdTime = javaType.createdTime(),
                description = javaType.description(),
                displayName = javaType.displayName(),
                id = javaType.id(),
                imageBuilderName = javaType.imageBuilderName(),
                imageBuilderSupported = javaType.imageBuilderSupported(),
                imagePermissions = javaType.imagePermissions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appstream.kotlin.outputs.GetImageImagePermission.Companion.toKotlin(args0)
                    })
                }),
                mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                platform = javaType.platform(),
                publicBaseImageReleasedDate = javaType.publicBaseImageReleasedDate(),
                state = javaType.state(),
                stateChangeReasons = javaType.stateChangeReasons().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appstream.kotlin.outputs.GetImageStateChangeReason.Companion.toKotlin(args0)
                    })
                }),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
