@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointType Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
 * @property vpceId Identifier (ID) of the interface VPC endpoint.
 */
public data class ImageBuilderAccessEndpoint(
    public val endpointType: String,
    public val vpceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.ImageBuilderAccessEndpoint): ImageBuilderAccessEndpoint = ImageBuilderAccessEndpoint(
            endpointType = javaType.endpointType(),
            vpceId = javaType.vpceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
