@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether application settings should be persisted.
 * @property settingsGroup Name of the settings group.
 * Required when `enabled` is `true`.
 * Can be up to 100 characters.
 */
public data class StackApplicationSettings(
    public val enabled: Boolean,
    public val settingsGroup: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.StackApplicationSettings): StackApplicationSettings = StackApplicationSettings(
            enabled = javaType.enabled(),
            settingsGroup = javaType.settingsGroup().map({ args0 -> args0 }).orElse(null),
        )
    }
}
