@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action Action that is enabled or disabled.
 * Valid values are `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`,  `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, `PRINTING_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, or `DOMAIN_SMART_CARD_SIGNIN`.
 * @property permission Whether the action is enabled or disabled.
 * Valid values are `ENABLED` or `DISABLED`.
 */
public data class StackUserSetting(
    public val action: String,
    public val permission: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.StackUserSetting): StackUserSetting = StackUserSetting(
            action = javaType.action(),
            permission = javaType.permission(),
        )
    }
}
