@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.ApiCacheArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync API Cache.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "example",
 * });
 * const exampleApiCache = new aws.appsync.ApiCache("example", {
 *     apiId: example.id,
 *     apiCachingBehavior: "FULL_REQUEST_CACHING",
 *     type: "LARGE",
 *     ttl: 900,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="example")
 * example_api_cache = aws.appsync.ApiCache("example",
 *     api_id=example.id,
 *     api_caching_behavior="FULL_REQUEST_CACHING",
 *     type="LARGE",
 *     ttl=900)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "example",
 *     });
 *     var exampleApiCache = new Aws.AppSync.ApiCache("example", new()
 *     {
 *         ApiId = example.Id,
 *         ApiCachingBehavior = "FULL_REQUEST_CACHING",
 *         Type = "LARGE",
 *         Ttl = 900,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewApiCache(ctx, "example", &appsync.ApiCacheArgs{
 * 			ApiId:              example.ID(),
 * 			ApiCachingBehavior: pulumi.String("FULL_REQUEST_CACHING"),
 * 			Type:               pulumi.String("LARGE"),
 * 			Ttl:                pulumi.Int(900),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.ApiCache;
 * import com.pulumi.aws.appsync.ApiCacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GraphQLApi("example", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("example")
 *             .build());
 *         var exampleApiCache = new ApiCache("exampleApiCache", ApiCacheArgs.builder()
 *             .apiId(example.id())
 *             .apiCachingBehavior("FULL_REQUEST_CACHING")
 *             .type("LARGE")
 *             .ttl(900)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: example
 *   exampleApiCache:
 *     type: aws:appsync:ApiCache
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       apiCachingBehavior: FULL_REQUEST_CACHING
 *       type: LARGE
 *       ttl: 900
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_api_cache` using the AppSync API ID. For example:
 * ```sh
 * $ pulumi import aws:appsync/apiCache:ApiCache example xxxxx
 * ```
 * @property apiCachingBehavior Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
 * @property apiId GraphQL API ID.
 * @property atRestEncryptionEnabled At-rest encryption flag for cache. You cannot update this setting after creation.
 * @property transitEncryptionEnabled Transit encryption flag when connecting to cache. You cannot update this setting after creation.
 * @property ttl TTL in seconds for cache entries.
 * @property type Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
 */
public data class ApiCacheArgs(
    public val apiCachingBehavior: Output<String>? = null,
    public val apiId: Output<String>? = null,
    public val atRestEncryptionEnabled: Output<Boolean>? = null,
    public val transitEncryptionEnabled: Output<Boolean>? = null,
    public val ttl: Output<Int>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.ApiCacheArgs> {
    override fun toJava(): com.pulumi.aws.appsync.ApiCacheArgs =
        com.pulumi.aws.appsync.ApiCacheArgs.builder()
            .apiCachingBehavior(apiCachingBehavior?.applyValue({ args0 -> args0 }))
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .atRestEncryptionEnabled(atRestEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .transitEncryptionEnabled(transitEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiCacheArgs].
 */
@PulumiTagMarker
public class ApiCacheArgsBuilder internal constructor() {
    private var apiCachingBehavior: Output<String>? = null

    private var apiId: Output<String>? = null

    private var atRestEncryptionEnabled: Output<Boolean>? = null

    private var transitEncryptionEnabled: Output<Boolean>? = null

    private var ttl: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
     */
    @JvmName("sfvnxlldgrchjcpw")
    public suspend fun apiCachingBehavior(`value`: Output<String>) {
        this.apiCachingBehavior = value
    }

    /**
     * @param value GraphQL API ID.
     */
    @JvmName("bufbfhowvlheohiu")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value At-rest encryption flag for cache. You cannot update this setting after creation.
     */
    @JvmName("wfyyypxdrsckadtq")
    public suspend fun atRestEncryptionEnabled(`value`: Output<Boolean>) {
        this.atRestEncryptionEnabled = value
    }

    /**
     * @param value Transit encryption flag when connecting to cache. You cannot update this setting after creation.
     */
    @JvmName("ohsypqcjmspjdcyi")
    public suspend fun transitEncryptionEnabled(`value`: Output<Boolean>) {
        this.transitEncryptionEnabled = value
    }

    /**
     * @param value TTL in seconds for cache entries.
     */
    @JvmName("omictnjltcnmpudc")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
     */
    @JvmName("nuavenartysflhfb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
     */
    @JvmName("qikcdkloypiokbgd")
    public suspend fun apiCachingBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiCachingBehavior = mapped
    }

    /**
     * @param value GraphQL API ID.
     */
    @JvmName("aovteqspyretirgv")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value At-rest encryption flag for cache. You cannot update this setting after creation.
     */
    @JvmName("ugguiisxhxpgktkv")
    public suspend fun atRestEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.atRestEncryptionEnabled = mapped
    }

    /**
     * @param value Transit encryption flag when connecting to cache. You cannot update this setting after creation.
     */
    @JvmName("useosytrhaawsblq")
    public suspend fun transitEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitEncryptionEnabled = mapped
    }

    /**
     * @param value TTL in seconds for cache entries.
     */
    @JvmName("kldrlieevabgjsba")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
     */
    @JvmName("qexpsueiqehvaluh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ApiCacheArgs = ApiCacheArgs(
        apiCachingBehavior = apiCachingBehavior,
        apiId = apiId,
        atRestEncryptionEnabled = atRestEncryptionEnabled,
        transitEncryptionEnabled = transitEncryptionEnabled,
        ttl = ttl,
        type = type,
    )
}
