@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiKey].
 */
@PulumiTagMarker
public class ApiKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiKeyArgs = ApiKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiKeyArgsBuilder.() -> Unit) {
        val builder = ApiKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApiKey {
        val builtJavaResource = com.pulumi.aws.appsync.ApiKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiKey(builtJavaResource)
    }
}

/**
 * Provides an AppSync API Key.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "example",
 * });
 * const exampleApiKey = new aws.appsync.ApiKey("example", {
 *     apiId: example.id,
 *     expires: "2018-05-03T04:00:00Z",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="example")
 * example_api_key = aws.appsync.ApiKey("example",
 *     api_id=example.id,
 *     expires="2018-05-03T04:00:00Z")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "example",
 *     });
 *     var exampleApiKey = new Aws.AppSync.ApiKey("example", new()
 *     {
 *         ApiId = example.Id,
 *         Expires = "2018-05-03T04:00:00Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewApiKey(ctx, "example", &appsync.ApiKeyArgs{
 * 			ApiId:   example.ID(),
 * 			Expires: pulumi.String("2018-05-03T04:00:00Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.ApiKey;
 * import com.pulumi.aws.appsync.ApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GraphQLApi("example", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("example")
 *             .build());
 *         var exampleApiKey = new ApiKey("exampleApiKey", ApiKeyArgs.builder()
 *             .apiId(example.id())
 *             .expires("2018-05-03T04:00:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: example
 *   exampleApiKey:
 *     type: aws:appsync:ApiKey
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       expires: 2018-05-03T04:00:00Z
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_api_key` using the AppSync API ID and key separated by `:`. For example:
 * ```sh
 * $ pulumi import aws:appsync/apiKey:ApiKey example xxxxx:yyyyy
 * ```
 */
public class ApiKey internal constructor(
    override val javaResource: com.pulumi.aws.appsync.ApiKey,
) : KotlinCustomResource(javaResource, ApiKeyMapper) {
    /**
     * ID of the associated AppSync API
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    public val apiKeyId: Output<String>
        get() = javaResource.apiKeyId().applyValue({ args0 -> args0 })

    /**
     * API key description. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * RFC3339 string representation of the expiry date. Rounded down to nearest hour. By default, it is 7 days from the date of creation.
     */
    public val expires: Output<String>?
        get() = javaResource.expires().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * API key
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })
}

public object ApiKeyMapper : ResourceMapper<ApiKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.ApiKey::class == javaResource::class

    override fun map(javaResource: Resource): ApiKey = ApiKey(
        javaResource as
            com.pulumi.aws.appsync.ApiKey,
    )
}

/**
 * @see [ApiKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiKey].
 */
public suspend fun apiKey(name: String, block: suspend ApiKeyResourceBuilder.() -> Unit): ApiKey {
    val builder = ApiKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiKey(name: String): ApiKey {
    val builder = ApiKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
