@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.ApiKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync API Key.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "example",
 * });
 * const exampleApiKey = new aws.appsync.ApiKey("example", {
 *     apiId: example.id,
 *     expires: "2018-05-03T04:00:00Z",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="example")
 * example_api_key = aws.appsync.ApiKey("example",
 *     api_id=example.id,
 *     expires="2018-05-03T04:00:00Z")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "example",
 *     });
 *     var exampleApiKey = new Aws.AppSync.ApiKey("example", new()
 *     {
 *         ApiId = example.Id,
 *         Expires = "2018-05-03T04:00:00Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewApiKey(ctx, "example", &appsync.ApiKeyArgs{
 * 			ApiId:   example.ID(),
 * 			Expires: pulumi.String("2018-05-03T04:00:00Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.ApiKey;
 * import com.pulumi.aws.appsync.ApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GraphQLApi("example", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("example")
 *             .build());
 *         var exampleApiKey = new ApiKey("exampleApiKey", ApiKeyArgs.builder()
 *             .apiId(example.id())
 *             .expires("2018-05-03T04:00:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: example
 *   exampleApiKey:
 *     type: aws:appsync:ApiKey
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       expires: 2018-05-03T04:00:00Z
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_api_key` using the AppSync API ID and key separated by `:`. For example:
 * ```sh
 * $ pulumi import aws:appsync/apiKey:ApiKey example xxxxx:yyyyy
 * ```
 * @property apiId ID of the associated AppSync API
 * @property description API key description. Defaults to "Managed by Pulumi".
 * @property expires RFC3339 string representation of the expiry date. Rounded down to nearest hour. By default, it is 7 days from the date of creation.
 */
public data class ApiKeyArgs(
    public val apiId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val expires: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.ApiKeyArgs> {
    override fun toJava(): com.pulumi.aws.appsync.ApiKeyArgs =
        com.pulumi.aws.appsync.ApiKeyArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .expires(expires?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiKeyArgs].
 */
@PulumiTagMarker
public class ApiKeyArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var description: Output<String>? = null

    private var expires: Output<String>? = null

    /**
     * @param value ID of the associated AppSync API
     */
    @JvmName("lhnfqewleulhgocn")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value API key description. Defaults to "Managed by Pulumi".
     */
    @JvmName("aoslptsjnkrfuqge")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value RFC3339 string representation of the expiry date. Rounded down to nearest hour. By default, it is 7 days from the date of creation.
     */
    @JvmName("rkmpmfbkinpqurct")
    public suspend fun expires(`value`: Output<String>) {
        this.expires = value
    }

    /**
     * @param value ID of the associated AppSync API
     */
    @JvmName("xisfyaynimcdxmay")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value API key description. Defaults to "Managed by Pulumi".
     */
    @JvmName("qiqdsntraxrvhrig")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value RFC3339 string representation of the expiry date. Rounded down to nearest hour. By default, it is 7 days from the date of creation.
     */
    @JvmName("tgwloypjibcgiwkx")
    public suspend fun expires(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expires = mapped
    }

    internal fun build(): ApiKeyArgs = ApiKeyArgs(
        apiId = apiId,
        description = description,
        expires = expires,
    )
}
