@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.kotlin.outputs.DataSourceDynamodbConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceElasticsearchConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceEventBridgeConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceHttpConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceLambdaConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceOpensearchserviceConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceRelationalDatabaseConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceDynamodbConfig.Companion.toKotlin as dataSourceDynamodbConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceElasticsearchConfig.Companion.toKotlin as dataSourceElasticsearchConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceEventBridgeConfig.Companion.toKotlin as dataSourceEventBridgeConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceHttpConfig.Companion.toKotlin as dataSourceHttpConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceLambdaConfig.Companion.toKotlin as dataSourceLambdaConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceOpensearchserviceConfig.Companion.toKotlin as dataSourceOpensearchserviceConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceRelationalDatabaseConfig.Companion.toKotlin as dataSourceRelationalDatabaseConfigToKotlin

/**
 * Builder for [DataSource].
 */
@PulumiTagMarker
public class DataSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataSourceArgs = DataSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataSourceArgsBuilder.() -> Unit) {
        val builder = DataSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataSource {
        val builtJavaResource = com.pulumi.aws.appsync.DataSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataSource(builtJavaResource)
    }
}

/**
 * Provides an AppSync Data Source.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleTable = new aws.dynamodb.Table("example", {
 *     name: "example",
 *     readCapacity: 1,
 *     writeCapacity: 1,
 *     hashKey: "UserId",
 *     attributes: [{
 *         name: "UserId",
 *         type: "S",
 *     }],
 * });
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["appsync&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const example = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["dynamodb:*"],
 *         resources: [exampleTable&#46;arn],
 *     }],
 * });
 * const exampleRolePolicy = new aws.iam.RolePolicy("example", {
 *     name: "example",
 *     role: exampleRole.id,
 *     policy: example.apply(example => example.json),
 * });
 * const exampleGraphQLApi = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "my_appsync_example",
 * });
 * const exampleDataSource = new aws.appsync.DataSource("example", {
 *     apiId: exampleGraphQLApi.id,
 *     name: "my_appsync_example",
 *     serviceRoleArn: exampleRole.arn,
 *     type: "AMAZON_DYNAMODB",
 *     dynamodbConfig: {
 *         tableName: exampleTable.name,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_table = aws.dynamodb.Table("example",
 *     name="example",
 *     read_capacity=1,
 *     write_capacity=1,
 *     hash_key="UserId",
 *     attributes=[{
 *         "name": "UserId",
 *         "type": "S",
 *     }])
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["appsync&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="example",
 *     assume_role_policy=assume_role.json)
 * example = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "actions": ["dynamodb:*"],
 *     "resources": [example_table&#46;arn],
 * }])
 * example_role_policy = aws.iam.RolePolicy("example",
 *     name="example",
 *     role=example_role.id,
 *     policy=example.json)
 * example_graph_ql_api = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="my_appsync_example")
 * example_data_source = aws.appsync.DataSource("example",
 *     api_id=example_graph_ql_api.id,
 *     name="my_appsync_example",
 *     service_role_arn=example_role.arn,
 *     type="AMAZON_DYNAMODB",
 *     dynamodb_config={
 *         "table_name": example_table.name,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleTable = new Aws.DynamoDB.Table("example", new()
 *     {
 *         Name = "example",
 *         ReadCapacity = 1,
 *         WriteCapacity = 1,
 *         HashKey = "UserId",
 *         Attributes = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.TableAttributeArgs
 *             {
 *                 Name = "UserId",
 *                 Type = "S",
 *             },
 *         },
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "appsync.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "dynamodb:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleTable.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRolePolicy = new Aws.Iam.RolePolicy("example", new()
 *     {
 *         Name = "example",
 *         Role = exampleRole.Id,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleGraphQLApi = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "my_appsync_example",
 *     });
 *     var exampleDataSource = new Aws.AppSync.DataSource("example", new()
 *     {
 *         ApiId = exampleGraphQLApi.Id,
 *         Name = "my_appsync_example",
 *         ServiceRoleArn = exampleRole.Arn,
 *         Type = "AMAZON_DYNAMODB",
 *         DynamodbConfig = new Aws.AppSync.Inputs.DataSourceDynamodbConfigArgs
 *         {
 *             TableName = exampleTable.Name,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleTable, err := dynamodb.NewTable(ctx, "example", &dynamodb.TableArgs{
 * 			Name:          pulumi.String("example"),
 * 			ReadCapacity:  pulumi.Int(1),
 * 			WriteCapacity: pulumi.Int(1),
 * 			HashKey:       pulumi.String("UserId"),
 * 			Attributes: dynamodb.TableAttributeArray{
 * 				&dynamodb.TableAttributeArgs{
 * 					Name: pulumi.String("UserId"),
 * 					Type: pulumi.String("S"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"appsync.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("dynamodb:*"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						exampleTable.Arn,
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = iam.NewRolePolicy(ctx, "example", &iam.RolePolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			Role: exampleRole.ID(),
 * 			Policy: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &example.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGraphQLApi, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("my_appsync_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewDataSource(ctx, "example", &appsync.DataSourceArgs{
 * 			ApiId:          exampleGraphQLApi.ID(),
 * 			Name:           pulumi.String("my_appsync_example"),
 * 			ServiceRoleArn: exampleRole.Arn,
 * 			Type:           pulumi.String("AMAZON_DYNAMODB"),
 * 			DynamodbConfig: &appsync.DataSourceDynamodbConfigArgs{
 * 				TableName: exampleTable.Name,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .name("example")
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .hashKey("UserId")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("UserId")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appsync.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("dynamodb:*")
 *                 .resources(exampleTable.arn())
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .name("example")
 *             .role(exampleRole.id())
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("my_appsync_example")
 *             .build());
 *         var exampleDataSource = new DataSource("exampleDataSource", DataSourceArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .name("my_appsync_example")
 *             .serviceRoleArn(exampleRole.arn())
 *             .type("AMAZON_DYNAMODB")
 *             .dynamodbConfig(DataSourceDynamodbConfigArgs.builder()
 *                 .tableName(exampleTable.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleTable:
 *     type: aws:dynamodb:Table
 *     name: example
 *     properties:
 *       name: example
 *       readCapacity: 1
 *       writeCapacity: 1
 *       hashKey: UserId
 *       attributes:
 *         - name: UserId
 *           type: S
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example
 *       assumeRolePolicy: ${assumeRole.json}
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       name: example
 *       role: ${exampleRole.id}
 *       policy: ${example.json}
 *   exampleGraphQLApi:
 *     type: aws:appsync:GraphQLApi
 *     name: example
 *     properties:
 *       authenticationType: API_KEY
 *       name: my_appsync_example
 *   exampleDataSource:
 *     type: aws:appsync:DataSource
 *     name: example
 *     properties:
 *       apiId: ${exampleGraphQLApi.id}
 *       name: my_appsync_example
 *       serviceRoleArn: ${exampleRole.arn}
 *       type: AMAZON_DYNAMODB
 *       dynamodbConfig:
 *         tableName: ${exampleTable.name}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - appsync.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - dynamodb:*
 *             resources:
 *               - ${exampleTable.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_datasource` using the `api_id`, a hyphen, and `name`. For example:
 * ```sh
 * $ pulumi import aws:appsync/dataSource:DataSource example abcdef123456-example
 * ```
 */
public class DataSource internal constructor(
    override val javaResource: com.pulumi.aws.appsync.DataSource,
) : KotlinCustomResource(javaResource, DataSourceMapper) {
    /**
     * API ID for the GraphQL API for the data source.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the data source.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DynamoDB settings. See `dynamodb_config` Block for details.
     */
    public val dynamodbConfig: Output<DataSourceDynamodbConfig>?
        get() = javaResource.dynamodbConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceDynamodbConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Amazon Elasticsearch settings. See `elasticsearch_config` Block for details.
     */
    public val elasticsearchConfig: Output<DataSourceElasticsearchConfig>?
        get() = javaResource.elasticsearchConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceElasticsearchConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * AWS EventBridge settings. See `event_bridge_config` Block for details.
     */
    public val eventBridgeConfig: Output<DataSourceEventBridgeConfig>?
        get() = javaResource.eventBridgeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceEventBridgeConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * HTTP settings. See `http_config` Block for details.
     */
    public val httpConfig: Output<DataSourceHttpConfig>?
        get() = javaResource.httpConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataSourceHttpConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * AWS Lambda settings. See `lambda_config` Block for details.
     */
    public val lambdaConfig: Output<DataSourceLambdaConfig>?
        get() = javaResource.lambdaConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataSourceLambdaConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * User-supplied name for the data source.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Amazon OpenSearch Service settings. See `opensearchservice_config` Block for details.
     */
    public val opensearchserviceConfig: Output<DataSourceOpensearchserviceConfig>?
        get() = javaResource.opensearchserviceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceOpensearchserviceConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * AWS RDS settings. See `relational_database_config` Block for details.
     */
    public val relationalDatabaseConfig: Output<DataSourceRelationalDatabaseConfig>?
        get() = javaResource.relationalDatabaseConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceRelationalDatabaseConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * IAM service role ARN for the data source. Required if `type` is specified as `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `AMAZON_EVENTBRIDGE`, or `AMAZON_OPENSEARCH_SERVICE`.
     */
    public val serviceRoleArn: Output<String>?
        get() = javaResource.serviceRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataSourceMapper : ResourceMapper<DataSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.DataSource::class == javaResource::class

    override fun map(javaResource: Resource): DataSource = DataSource(
        javaResource as
            com.pulumi.aws.appsync.DataSource,
    )
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataSource].
 */
public suspend fun dataSource(name: String, block: suspend DataSourceResourceBuilder.() -> Unit): DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataSource(name: String): DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
