@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.DataSourceArgs.builder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceDynamodbConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceDynamodbConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceElasticsearchConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceElasticsearchConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceEventBridgeConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceEventBridgeConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceHttpConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceHttpConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceLambdaConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceLambdaConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceOpensearchserviceConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceOpensearchserviceConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceRelationalDatabaseConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceRelationalDatabaseConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Data Source.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleTable = new aws.dynamodb.Table("example", {
 *     name: "example",
 *     readCapacity: 1,
 *     writeCapacity: 1,
 *     hashKey: "UserId",
 *     attributes: [{
 *         name: "UserId",
 *         type: "S",
 *     }],
 * });
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["appsync&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const example = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["dynamodb:*"],
 *         resources: [exampleTable&#46;arn],
 *     }],
 * });
 * const exampleRolePolicy = new aws.iam.RolePolicy("example", {
 *     name: "example",
 *     role: exampleRole.id,
 *     policy: example.apply(example => example.json),
 * });
 * const exampleGraphQLApi = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "my_appsync_example",
 * });
 * const exampleDataSource = new aws.appsync.DataSource("example", {
 *     apiId: exampleGraphQLApi.id,
 *     name: "my_appsync_example",
 *     serviceRoleArn: exampleRole.arn,
 *     type: "AMAZON_DYNAMODB",
 *     dynamodbConfig: {
 *         tableName: exampleTable.name,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_table = aws.dynamodb.Table("example",
 *     name="example",
 *     read_capacity=1,
 *     write_capacity=1,
 *     hash_key="UserId",
 *     attributes=[{
 *         "name": "UserId",
 *         "type": "S",
 *     }])
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["appsync&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="example",
 *     assume_role_policy=assume_role.json)
 * example = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "actions": ["dynamodb:*"],
 *     "resources": [example_table&#46;arn],
 * }])
 * example_role_policy = aws.iam.RolePolicy("example",
 *     name="example",
 *     role=example_role.id,
 *     policy=example.json)
 * example_graph_ql_api = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="my_appsync_example")
 * example_data_source = aws.appsync.DataSource("example",
 *     api_id=example_graph_ql_api.id,
 *     name="my_appsync_example",
 *     service_role_arn=example_role.arn,
 *     type="AMAZON_DYNAMODB",
 *     dynamodb_config={
 *         "table_name": example_table.name,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleTable = new Aws.DynamoDB.Table("example", new()
 *     {
 *         Name = "example",
 *         ReadCapacity = 1,
 *         WriteCapacity = 1,
 *         HashKey = "UserId",
 *         Attributes = new[]
 *         {
 *             new Aws.DynamoDB.Inputs.TableAttributeArgs
 *             {
 *                 Name = "UserId",
 *                 Type = "S",
 *             },
 *         },
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "appsync.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "dynamodb:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleTable.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRolePolicy = new Aws.Iam.RolePolicy("example", new()
 *     {
 *         Name = "example",
 *         Role = exampleRole.Id,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleGraphQLApi = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "my_appsync_example",
 *     });
 *     var exampleDataSource = new Aws.AppSync.DataSource("example", new()
 *     {
 *         ApiId = exampleGraphQLApi.Id,
 *         Name = "my_appsync_example",
 *         ServiceRoleArn = exampleRole.Arn,
 *         Type = "AMAZON_DYNAMODB",
 *         DynamodbConfig = new Aws.AppSync.Inputs.DataSourceDynamodbConfigArgs
 *         {
 *             TableName = exampleTable.Name,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dynamodb"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleTable, err := dynamodb.NewTable(ctx, "example", &dynamodb.TableArgs{
 * 			Name:          pulumi.String("example"),
 * 			ReadCapacity:  pulumi.Int(1),
 * 			WriteCapacity: pulumi.Int(1),
 * 			HashKey:       pulumi.String("UserId"),
 * 			Attributes: dynamodb.TableAttributeArray{
 * 				&dynamodb.TableAttributeArgs{
 * 					Name: pulumi.String("UserId"),
 * 					Type: pulumi.String("S"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"appsync.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("dynamodb:*"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						exampleTable.Arn,
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = iam.NewRolePolicy(ctx, "example", &iam.RolePolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			Role: exampleRole.ID(),
 * 			Policy: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &example.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGraphQLApi, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("my_appsync_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewDataSource(ctx, "example", &appsync.DataSourceArgs{
 * 			ApiId:          exampleGraphQLApi.ID(),
 * 			Name:           pulumi.String("my_appsync_example"),
 * 			ServiceRoleArn: exampleRole.Arn,
 * 			Type:           pulumi.String("AMAZON_DYNAMODB"),
 * 			DynamodbConfig: &appsync.DataSourceDynamodbConfigArgs{
 * 				TableName: exampleTable.Name,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .name("example")
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .hashKey("UserId")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("UserId")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appsync.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("dynamodb:*")
 *                 .resources(exampleTable.arn())
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .name("example")
 *             .role(exampleRole.id())
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("my_appsync_example")
 *             .build());
 *         var exampleDataSource = new DataSource("exampleDataSource", DataSourceArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .name("my_appsync_example")
 *             .serviceRoleArn(exampleRole.arn())
 *             .type("AMAZON_DYNAMODB")
 *             .dynamodbConfig(DataSourceDynamodbConfigArgs.builder()
 *                 .tableName(exampleTable.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleTable:
 *     type: aws:dynamodb:Table
 *     name: example
 *     properties:
 *       name: example
 *       readCapacity: 1
 *       writeCapacity: 1
 *       hashKey: UserId
 *       attributes:
 *         - name: UserId
 *           type: S
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example
 *       assumeRolePolicy: ${assumeRole.json}
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       name: example
 *       role: ${exampleRole.id}
 *       policy: ${example.json}
 *   exampleGraphQLApi:
 *     type: aws:appsync:GraphQLApi
 *     name: example
 *     properties:
 *       authenticationType: API_KEY
 *       name: my_appsync_example
 *   exampleDataSource:
 *     type: aws:appsync:DataSource
 *     name: example
 *     properties:
 *       apiId: ${exampleGraphQLApi.id}
 *       name: my_appsync_example
 *       serviceRoleArn: ${exampleRole.arn}
 *       type: AMAZON_DYNAMODB
 *       dynamodbConfig:
 *         tableName: ${exampleTable.name}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - appsync.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - dynamodb:*
 *             resources:
 *               - ${exampleTable.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_datasource` using the `api_id`, a hyphen, and `name`. For example:
 * ```sh
 * $ pulumi import aws:appsync/dataSource:DataSource example abcdef123456-example
 * ```
 * @property apiId API ID for the GraphQL API for the data source.
 * @property description Description of the data source.
 * @property dynamodbConfig DynamoDB settings. See `dynamodb_config` Block for details.
 * @property elasticsearchConfig Amazon Elasticsearch settings. See `elasticsearch_config` Block for details.
 * @property eventBridgeConfig AWS EventBridge settings. See `event_bridge_config` Block for details.
 * @property httpConfig HTTP settings. See `http_config` Block for details.
 * @property lambdaConfig AWS Lambda settings. See `lambda_config` Block for details.
 * @property name User-supplied name for the data source.
 * @property opensearchserviceConfig Amazon OpenSearch Service settings. See `opensearchservice_config` Block for details.
 * @property relationalDatabaseConfig AWS RDS settings. See `relational_database_config` Block for details.
 * @property serviceRoleArn IAM service role ARN for the data source. Required if `type` is specified as `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `AMAZON_EVENTBRIDGE`, or `AMAZON_OPENSEARCH_SERVICE`.
 * @property type Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
 */
public data class DataSourceArgs(
    public val apiId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val dynamodbConfig: Output<DataSourceDynamodbConfigArgs>? = null,
    public val elasticsearchConfig: Output<DataSourceElasticsearchConfigArgs>? = null,
    public val eventBridgeConfig: Output<DataSourceEventBridgeConfigArgs>? = null,
    public val httpConfig: Output<DataSourceHttpConfigArgs>? = null,
    public val lambdaConfig: Output<DataSourceLambdaConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val opensearchserviceConfig: Output<DataSourceOpensearchserviceConfigArgs>? = null,
    public val relationalDatabaseConfig: Output<DataSourceRelationalDatabaseConfigArgs>? = null,
    public val serviceRoleArn: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.DataSourceArgs> {
    override fun toJava(): com.pulumi.aws.appsync.DataSourceArgs =
        com.pulumi.aws.appsync.DataSourceArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dynamodbConfig(dynamodbConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .elasticsearchConfig(
                elasticsearchConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .eventBridgeConfig(eventBridgeConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpConfig(httpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lambdaConfig(lambdaConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .opensearchserviceConfig(
                opensearchserviceConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .relationalDatabaseConfig(
                relationalDatabaseConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serviceRoleArn(serviceRoleArn?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceArgs].
 */
@PulumiTagMarker
public class DataSourceArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var description: Output<String>? = null

    private var dynamodbConfig: Output<DataSourceDynamodbConfigArgs>? = null

    private var elasticsearchConfig: Output<DataSourceElasticsearchConfigArgs>? = null

    private var eventBridgeConfig: Output<DataSourceEventBridgeConfigArgs>? = null

    private var httpConfig: Output<DataSourceHttpConfigArgs>? = null

    private var lambdaConfig: Output<DataSourceLambdaConfigArgs>? = null

    private var name: Output<String>? = null

    private var opensearchserviceConfig: Output<DataSourceOpensearchserviceConfigArgs>? = null

    private var relationalDatabaseConfig: Output<DataSourceRelationalDatabaseConfigArgs>? = null

    private var serviceRoleArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value API ID for the GraphQL API for the data source.
     */
    @JvmName("nkvjfwtesjqtguvq")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Description of the data source.
     */
    @JvmName("aharcsevvtwkhvij")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value DynamoDB settings. See `dynamodb_config` Block for details.
     */
    @JvmName("xxudvhqifshanjhv")
    public suspend fun dynamodbConfig(`value`: Output<DataSourceDynamodbConfigArgs>) {
        this.dynamodbConfig = value
    }

    /**
     * @param value Amazon Elasticsearch settings. See `elasticsearch_config` Block for details.
     */
    @JvmName("umttorxmcgbdbomw")
    public suspend fun elasticsearchConfig(`value`: Output<DataSourceElasticsearchConfigArgs>) {
        this.elasticsearchConfig = value
    }

    /**
     * @param value AWS EventBridge settings. See `event_bridge_config` Block for details.
     */
    @JvmName("uttsnjliihcdspay")
    public suspend fun eventBridgeConfig(`value`: Output<DataSourceEventBridgeConfigArgs>) {
        this.eventBridgeConfig = value
    }

    /**
     * @param value HTTP settings. See `http_config` Block for details.
     */
    @JvmName("mhswuinjkdhmlrmf")
    public suspend fun httpConfig(`value`: Output<DataSourceHttpConfigArgs>) {
        this.httpConfig = value
    }

    /**
     * @param value AWS Lambda settings. See `lambda_config` Block for details.
     */
    @JvmName("cvogrqdxcgladuov")
    public suspend fun lambdaConfig(`value`: Output<DataSourceLambdaConfigArgs>) {
        this.lambdaConfig = value
    }

    /**
     * @param value User-supplied name for the data source.
     */
    @JvmName("qidjmaeptkmtxsyp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Amazon OpenSearch Service settings. See `opensearchservice_config` Block for details.
     */
    @JvmName("cdgqgpqddghxydij")
    public suspend fun opensearchserviceConfig(`value`: Output<DataSourceOpensearchserviceConfigArgs>) {
        this.opensearchserviceConfig = value
    }

    /**
     * @param value AWS RDS settings. See `relational_database_config` Block for details.
     */
    @JvmName("bvkluxrbhjotnych")
    public suspend fun relationalDatabaseConfig(`value`: Output<DataSourceRelationalDatabaseConfigArgs>) {
        this.relationalDatabaseConfig = value
    }

    /**
     * @param value IAM service role ARN for the data source. Required if `type` is specified as `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `AMAZON_EVENTBRIDGE`, or `AMAZON_OPENSEARCH_SERVICE`.
     */
    @JvmName("qjvfvfmqktvuxwkv")
    public suspend fun serviceRoleArn(`value`: Output<String>) {
        this.serviceRoleArn = value
    }

    /**
     * @param value Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
     */
    @JvmName("klbodfudccyghixe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value API ID for the GraphQL API for the data source.
     */
    @JvmName("uaxjtjjutvbyxiut")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Description of the data source.
     */
    @JvmName("jbcomqhukavxdroy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value DynamoDB settings. See `dynamodb_config` Block for details.
     */
    @JvmName("jderejxsctnhntvk")
    public suspend fun dynamodbConfig(`value`: DataSourceDynamodbConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbConfig = mapped
    }

    /**
     * @param argument DynamoDB settings. See `dynamodb_config` Block for details.
     */
    @JvmName("bdfihqxkhdjyexdp")
    public suspend fun dynamodbConfig(argument: suspend DataSourceDynamodbConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceDynamodbConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dynamodbConfig = mapped
    }

    /**
     * @param value Amazon Elasticsearch settings. See `elasticsearch_config` Block for details.
     */
    @JvmName("tbltvfgblcecencn")
    public suspend fun elasticsearchConfig(`value`: DataSourceElasticsearchConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchConfig = mapped
    }

    /**
     * @param argument Amazon Elasticsearch settings. See `elasticsearch_config` Block for details.
     */
    @JvmName("ttfguacrihqwukmb")
    public suspend fun elasticsearchConfig(argument: suspend DataSourceElasticsearchConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceElasticsearchConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.elasticsearchConfig = mapped
    }

    /**
     * @param value AWS EventBridge settings. See `event_bridge_config` Block for details.
     */
    @JvmName("uocttvxkxexbqgug")
    public suspend fun eventBridgeConfig(`value`: DataSourceEventBridgeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBridgeConfig = mapped
    }

    /**
     * @param argument AWS EventBridge settings. See `event_bridge_config` Block for details.
     */
    @JvmName("dkyodcryqorabqig")
    public suspend fun eventBridgeConfig(argument: suspend DataSourceEventBridgeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceEventBridgeConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventBridgeConfig = mapped
    }

    /**
     * @param value HTTP settings. See `http_config` Block for details.
     */
    @JvmName("chrscxdwwcoksmnj")
    public suspend fun httpConfig(`value`: DataSourceHttpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpConfig = mapped
    }

    /**
     * @param argument HTTP settings. See `http_config` Block for details.
     */
    @JvmName("trnfcxyjihgrkomu")
    public suspend fun httpConfig(argument: suspend DataSourceHttpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceHttpConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpConfig = mapped
    }

    /**
     * @param value AWS Lambda settings. See `lambda_config` Block for details.
     */
    @JvmName("jmjqwuojkndsjgrx")
    public suspend fun lambdaConfig(`value`: DataSourceLambdaConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaConfig = mapped
    }

    /**
     * @param argument AWS Lambda settings. See `lambda_config` Block for details.
     */
    @JvmName("yltvngbjcubgmlbq")
    public suspend fun lambdaConfig(argument: suspend DataSourceLambdaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceLambdaConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lambdaConfig = mapped
    }

    /**
     * @param value User-supplied name for the data source.
     */
    @JvmName("pscwlruflmahydlj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Amazon OpenSearch Service settings. See `opensearchservice_config` Block for details.
     */
    @JvmName("kkbcdhnhvavvodte")
    public suspend fun opensearchserviceConfig(`value`: DataSourceOpensearchserviceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchserviceConfig = mapped
    }

    /**
     * @param argument Amazon OpenSearch Service settings. See `opensearchservice_config` Block for details.
     */
    @JvmName("lxrsslrouvgnngpm")
    public suspend fun opensearchserviceConfig(argument: suspend DataSourceOpensearchserviceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceOpensearchserviceConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.opensearchserviceConfig = mapped
    }

    /**
     * @param value AWS RDS settings. See `relational_database_config` Block for details.
     */
    @JvmName("sguvixqtvogobnnl")
    public suspend fun relationalDatabaseConfig(`value`: DataSourceRelationalDatabaseConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationalDatabaseConfig = mapped
    }

    /**
     * @param argument AWS RDS settings. See `relational_database_config` Block for details.
     */
    @JvmName("ovhooysstcdonknr")
    public suspend fun relationalDatabaseConfig(argument: suspend DataSourceRelationalDatabaseConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceRelationalDatabaseConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.relationalDatabaseConfig = mapped
    }

    /**
     * @param value IAM service role ARN for the data source. Required if `type` is specified as `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `AMAZON_EVENTBRIDGE`, or `AMAZON_OPENSEARCH_SERVICE`.
     */
    @JvmName("oilffjhuloefyjuc")
    public suspend fun serviceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRoleArn = mapped
    }

    /**
     * @param value Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
     */
    @JvmName("ocitfakphysjikik")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataSourceArgs = DataSourceArgs(
        apiId = apiId,
        description = description,
        dynamodbConfig = dynamodbConfig,
        elasticsearchConfig = elasticsearchConfig,
        eventBridgeConfig = eventBridgeConfig,
        httpConfig = httpConfig,
        lambdaConfig = lambdaConfig,
        name = name,
        opensearchserviceConfig = opensearchserviceConfig,
        relationalDatabaseConfig = relationalDatabaseConfig,
        serviceRoleArn = serviceRoleArn,
        type = type,
    )
}
