@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainNameApiAssociation].
 */
@PulumiTagMarker
public class DomainNameApiAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainNameApiAssociationArgs = DomainNameApiAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainNameApiAssociationArgsBuilder.() -> Unit) {
        val builder = DomainNameApiAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainNameApiAssociation {
        val builtJavaResource = com.pulumi.aws.appsync.DomainNameApiAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainNameApiAssociation(builtJavaResource)
    }
}

/**
 * Provides an AppSync API Association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.DomainNameApiAssociation("example", {
 *     apiId: exampleAwsAppsyncGraphqlApi.id,
 *     domainName: exampleAwsAppsyncDomainName.domainName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.DomainNameApiAssociation("example",
 *     api_id=example_aws_appsync_graphql_api["id"],
 *     domain_name=example_aws_appsync_domain_name["domainName"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.DomainNameApiAssociation("example", new()
 *     {
 *         ApiId = exampleAwsAppsyncGraphqlApi.Id,
 *         DomainName = exampleAwsAppsyncDomainName.DomainName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appsync.NewDomainNameApiAssociation(ctx, "example", &appsync.DomainNameApiAssociationArgs{
 * 			ApiId:      pulumi.Any(exampleAwsAppsyncGraphqlApi.Id),
 * 			DomainName: pulumi.Any(exampleAwsAppsyncDomainName.DomainName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.DomainNameApiAssociation;
 * import com.pulumi.aws.appsync.DomainNameApiAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainNameApiAssociation("example", DomainNameApiAssociationArgs.builder()
 *             .apiId(exampleAwsAppsyncGraphqlApi.id())
 *             .domainName(exampleAwsAppsyncDomainName.domainName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:DomainNameApiAssociation
 *     properties:
 *       apiId: ${exampleAwsAppsyncGraphqlApi.id}
 *       domainName: ${exampleAwsAppsyncDomainName.domainName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_domain_name_api_association` using the AppSync domain name. For example:
 * ```sh
 * $ pulumi import aws:appsync/domainNameApiAssociation:DomainNameApiAssociation example example.com
 * ```
 */
public class DomainNameApiAssociation internal constructor(
    override val javaResource: com.pulumi.aws.appsync.DomainNameApiAssociation,
) : KotlinCustomResource(javaResource, DomainNameApiAssociationMapper) {
    /**
     * API ID.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * Appsync domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })
}

public object DomainNameApiAssociationMapper : ResourceMapper<DomainNameApiAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.DomainNameApiAssociation::class == javaResource::class

    override fun map(javaResource: Resource): DomainNameApiAssociation =
        DomainNameApiAssociation(javaResource as com.pulumi.aws.appsync.DomainNameApiAssociation)
}

/**
 * @see [DomainNameApiAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainNameApiAssociation].
 */
public suspend fun domainNameApiAssociation(
    name: String,
    block: suspend DomainNameApiAssociationResourceBuilder.() -> Unit,
): DomainNameApiAssociation {
    val builder = DomainNameApiAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainNameApiAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainNameApiAssociation(name: String): DomainNameApiAssociation {
    val builder = DomainNameApiAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
