@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.DomainNameApiAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync API Association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.DomainNameApiAssociation("example", {
 *     apiId: exampleAwsAppsyncGraphqlApi.id,
 *     domainName: exampleAwsAppsyncDomainName.domainName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.DomainNameApiAssociation("example",
 *     api_id=example_aws_appsync_graphql_api["id"],
 *     domain_name=example_aws_appsync_domain_name["domainName"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.DomainNameApiAssociation("example", new()
 *     {
 *         ApiId = exampleAwsAppsyncGraphqlApi.Id,
 *         DomainName = exampleAwsAppsyncDomainName.DomainName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appsync.NewDomainNameApiAssociation(ctx, "example", &appsync.DomainNameApiAssociationArgs{
 * 			ApiId:      pulumi.Any(exampleAwsAppsyncGraphqlApi.Id),
 * 			DomainName: pulumi.Any(exampleAwsAppsyncDomainName.DomainName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.DomainNameApiAssociation;
 * import com.pulumi.aws.appsync.DomainNameApiAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainNameApiAssociation("example", DomainNameApiAssociationArgs.builder()
 *             .apiId(exampleAwsAppsyncGraphqlApi.id())
 *             .domainName(exampleAwsAppsyncDomainName.domainName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:DomainNameApiAssociation
 *     properties:
 *       apiId: ${exampleAwsAppsyncGraphqlApi.id}
 *       domainName: ${exampleAwsAppsyncDomainName.domainName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_domain_name_api_association` using the AppSync domain name. For example:
 * ```sh
 * $ pulumi import aws:appsync/domainNameApiAssociation:DomainNameApiAssociation example example.com
 * ```
 * @property apiId API ID.
 * @property domainName Appsync domain name.
 */
public data class DomainNameApiAssociationArgs(
    public val apiId: Output<String>? = null,
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.DomainNameApiAssociationArgs> {
    override fun toJava(): com.pulumi.aws.appsync.DomainNameApiAssociationArgs =
        com.pulumi.aws.appsync.DomainNameApiAssociationArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNameApiAssociationArgs].
 */
@PulumiTagMarker
public class DomainNameApiAssociationArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var domainName: Output<String>? = null

    /**
     * @param value API ID.
     */
    @JvmName("mcskeskjvomdqnfo")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Appsync domain name.
     */
    @JvmName("xwhmrgbahfjqevxv")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value API ID.
     */
    @JvmName("hjlbvsuljionkfbs")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Appsync domain name.
     */
    @JvmName("ikkywyeukuhonspb")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainNameApiAssociationArgs = DomainNameApiAssociationArgs(
        apiId = apiId,
        domainName = domainName,
    )
}
