@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.DomainNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Domain Name.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.DomainName("example", {
 *     domainName: "api.example.com",
 *     certificateArn: exampleAwsAcmCertificate.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.DomainName("example",
 *     domain_name="api.example.com",
 *     certificate_arn=example_aws_acm_certificate["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.DomainName("example", new()
 *     {
 *         Name = "api.example.com",
 *         CertificateArn = exampleAwsAcmCertificate.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appsync.NewDomainName(ctx, "example", &appsync.DomainNameArgs{
 * 			DomainName:     pulumi.String("api.example.com"),
 * 			CertificateArn: pulumi.Any(exampleAwsAcmCertificate.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.DomainName;
 * import com.pulumi.aws.appsync.DomainNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainName("example", DomainNameArgs.builder()
 *             .domainName("api.example.com")
 *             .certificateArn(exampleAwsAcmCertificate.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:DomainName
 *     properties:
 *       domainName: api.example.com
 *       certificateArn: ${exampleAwsAcmCertificate.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_domain_name` using the AppSync domain name. For example:
 * ```sh
 * $ pulumi import aws:appsync/domainName:DomainName example example.com
 * ```
 * @property certificateArn ARN of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate. The certifiacte must reside in us-east-1.
 * @property description A description of the Domain Name.
 * @property domainName Domain name.
 */
public data class DomainNameArgs(
    public val certificateArn: Output<String>? = null,
    public val description: Output<String>? = null,
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.DomainNameArgs> {
    override fun toJava(): com.pulumi.aws.appsync.DomainNameArgs =
        com.pulumi.aws.appsync.DomainNameArgs.builder()
            .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNameArgs].
 */
@PulumiTagMarker
public class DomainNameArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    private var description: Output<String>? = null

    private var domainName: Output<String>? = null

    /**
     * @param value ARN of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate. The certifiacte must reside in us-east-1.
     */
    @JvmName("hywgixfissqytpom")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value A description of the Domain Name.
     */
    @JvmName("qidhqhqadbhfaygo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Domain name.
     */
    @JvmName("ddordwqsuuxurhbi")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value ARN of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate. The certifiacte must reside in us-east-1.
     */
    @JvmName("rrhtugkhdifuwtnp")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value A description of the Domain Name.
     */
    @JvmName("lbwvuwhorpqxekvs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Domain name.
     */
    @JvmName("fsdykrgbslvqnbfx")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainNameArgs = DomainNameArgs(
        certificateArn = certificateArn,
        description = description,
        domainName = domainName,
    )
}
