@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.kotlin.outputs.FunctionRuntime
import com.pulumi.aws.appsync.kotlin.outputs.FunctionSyncConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.appsync.kotlin.outputs.FunctionRuntime.Companion.toKotlin as functionRuntimeToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.FunctionSyncConfig.Companion.toKotlin as functionSyncConfigToKotlin

/**
 * Builder for [Function].
 */
@PulumiTagMarker
public class FunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FunctionArgs = FunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FunctionArgsBuilder.() -> Unit) {
        val builder = FunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Function {
        val builtJavaResource = com.pulumi.aws.appsync.Function(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Function(builtJavaResource)
    }
}

/**
 * Provides an AppSync Function.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "example",
 *     schema: `type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 * `,
 * });
 * const exampleDataSource = new aws.appsync.DataSource("example", {
 *     apiId: example.id,
 *     name: "example",
 *     type: "HTTP",
 *     httpConfig: {
 *         endpoint: "http://example.com",
 *     },
 * });
 * const exampleFunction = new aws.appsync.Function("example", {
 *     apiId: example.id,
 *     dataSource: exampleDataSource.name,
 *     name: "example",
 *     requestMappingTemplate: `{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": utils.http.copyheaders(ctx.request.headers)
 *     }
 * }
 * `,
 *     responseMappingTemplate: `#if(ctx.result.statusCode == 200)
 *     ctx.result.body
 * #else
 *     utils.appendError(ctx.result.body, ctx.result.statusCode)
 * #end
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="example",
 *     schema="""type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 * """)
 * example_data_source = aws.appsync.DataSource("example",
 *     api_id=example.id,
 *     name="example",
 *     type="HTTP",
 *     http_config={
 *         "endpoint": "http://example.com",
 *     })
 * example_function = aws.appsync.Function("example",
 *     api_id=example.id,
 *     data_source=example_data_source.name,
 *     name="example",
 *     request_mapping_template="""{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * """,
 *     response_mapping_template="""#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "example",
 *         Schema = @"type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 * ",
 *     });
 *     var exampleDataSource = new Aws.AppSync.DataSource("example", new()
 *     {
 *         ApiId = example.Id,
 *         Name = "example",
 *         Type = "HTTP",
 *         HttpConfig = new Aws.AppSync.Inputs.DataSourceHttpConfigArgs
 *         {
 *             Endpoint = "http://example.com",
 *         },
 *     });
 *     var exampleFunction = new Aws.AppSync.Function("example", new()
 *     {
 *         ApiId = example.Id,
 *         DataSource = exampleDataSource.Name,
 *         Name = "example",
 *         RequestMappingTemplate = @"{
 *     ""version"": ""2018-05-29"",
 *     ""method"": ""GET"",
 *     ""resourcePath"": ""/"",
 *     ""params"":{
 *         ""headers"": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * ",
 *         ResponseMappingTemplate = @"#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("example"),
 * 			Schema: pulumi.String(`type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDataSource, err := appsync.NewDataSource(ctx, "example", &appsync.DataSourceArgs{
 * 			ApiId: example.ID(),
 * 			Name:  pulumi.String("example"),
 * 			Type:  pulumi.String("HTTP"),
 * 			HttpConfig: &appsync.DataSourceHttpConfigArgs{
 * 				Endpoint: pulumi.String("http://example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewFunction(ctx, "example", &appsync.FunctionArgs{
 * 			ApiId:      example.ID(),
 * 			DataSource: exampleDataSource.Name,
 * 			Name:       pulumi.String("example"),
 * 			RequestMappingTemplate: pulumi.String(`{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * `),
 * 			ResponseMappingTemplate: pulumi.String(`#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs;
 * import com.pulumi.aws.appsync.Function;
 * import com.pulumi.aws.appsync.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GraphQLApi("example", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("example")
 *             .schema("""
 * type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 *             """)
 *             .build());
 *         var exampleDataSource = new DataSource("exampleDataSource", DataSourceArgs.builder()
 *             .apiId(example.id())
 *             .name("example")
 *             .type("HTTP")
 *             .httpConfig(DataSourceHttpConfigArgs.builder()
 *                 .endpoint("http://example.com")
 *                 .build())
 *             .build());
 *         var exampleFunction = new Function("exampleFunction", FunctionArgs.builder()
 *             .apiId(example.id())
 *             .dataSource(exampleDataSource.name())
 *             .name("example")
 *             .requestMappingTemplate("""
 * {
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 *             """)
 *             .responseMappingTemplate("""
 * #if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: example
 *       schema: |
 *         type Mutation {
 *           putPost(id: ID!, title: String!): Post
 *         }
 *         type Post {
 *           id: ID!
 *           title: String!
 *         }
 *         type Query {
 *           singlePost(id: ID!): Post
 *         }
 *         schema {
 *           query: Query
 *           mutation: Mutation
 *         }
 *   exampleDataSource:
 *     type: aws:appsync:DataSource
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       name: example
 *       type: HTTP
 *       httpConfig:
 *         endpoint: http://example.com
 *   exampleFunction:
 *     type: aws:appsync:Function
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       dataSource: ${exampleDataSource.name}
 *       name: example
 *       requestMappingTemplate: |
 *         {
 *             "version": "2018-05-29",
 *             "method": "GET",
 *             "resourcePath": "/",
 *             "params":{
 *                 "headers": $utils.http.copyheaders($ctx.request.headers)
 *             }
 *         }
 *       responseMappingTemplate: |
 *         #if($ctx.result.statusCode == 200)
 *             $ctx.result.body
 *         #else
 *             $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 *         #end
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Code
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.appsync.Function("example", {
 *     apiId: exampleAwsAppsyncGraphqlApi.id,
 *     dataSource: exampleAwsAppsyncDatasource.name,
 *     name: "example",
 *     code: std.file({
 *         input: "some-code-dir",
 *     }).then(invoke => invoke.result),
 *     runtime: {
 *         name: "APPSYNC_JS",
 *         runtimeVersion: "1.0.0",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.appsync.Function("example",
 *     api_id=example_aws_appsync_graphql_api["id"],
 *     data_source=example_aws_appsync_datasource["name"],
 *     name="example",
 *     code=std.file(input="some-code-dir").result,
 *     runtime={
 *         "name": "APPSYNC_JS",
 *         "runtime_version": "1.0.0",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.Function("example", new()
 *     {
 *         ApiId = exampleAwsAppsyncGraphqlApi.Id,
 *         DataSource = exampleAwsAppsyncDatasource.Name,
 *         Name = "example",
 *         Code = Std.File.Invoke(new()
 *         {
 *             Input = "some-code-dir",
 *         }).Apply(invoke => invoke.Result),
 *         Runtime = new Aws.AppSync.Inputs.FunctionRuntimeArgs
 *         {
 *             Name = "APPSYNC_JS",
 *             RuntimeVersion = "1.0.0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "some-code-dir",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewFunction(ctx, "example", &appsync.FunctionArgs{
 * 			ApiId:      pulumi.Any(exampleAwsAppsyncGraphqlApi.Id),
 * 			DataSource: pulumi.Any(exampleAwsAppsyncDatasource.Name),
 * 			Name:       pulumi.String("example"),
 * 			Code:       pulumi.String(invokeFile.Result),
 * 			Runtime: &appsync.FunctionRuntimeArgs{
 * 				Name:           pulumi.String("APPSYNC_JS"),
 * 				RuntimeVersion: pulumi.String("1.0.0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.Function;
 * import com.pulumi.aws.appsync.FunctionArgs;
 * import com.pulumi.aws.appsync.inputs.FunctionRuntimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Function("example", FunctionArgs.builder()
 *             .apiId(exampleAwsAppsyncGraphqlApi.id())
 *             .dataSource(exampleAwsAppsyncDatasource.name())
 *             .name("example")
 *             .code(StdFunctions.file(FileArgs.builder()
 *                 .input("some-code-dir")
 *                 .build()).result())
 *             .runtime(FunctionRuntimeArgs.builder()
 *                 .name("APPSYNC_JS")
 *                 .runtimeVersion("1.0.0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:Function
 *     properties:
 *       apiId: ${exampleAwsAppsyncGraphqlApi.id}
 *       dataSource: ${exampleAwsAppsyncDatasource.name}
 *       name: example
 *       code:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: some-code-dir
 *           Return: result
 *       runtime:
 *         name: APPSYNC_JS
 *         runtimeVersion: 1.0.0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_function` using the AppSync API ID and Function ID separated by `-`. For example:
 * ```sh
 * $ pulumi import aws:appsync/function:Function example xxxxx-yyyyy
 * ```
 */
public class Function internal constructor(
    override val javaResource: com.pulumi.aws.appsync.Function,
) : KotlinCustomResource(javaResource, FunctionMapper) {
    /**
     * ID of the associated AppSync API.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * ARN of the Function object.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    public val code: Output<String>?
        get() = javaResource.code().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Function data source name.
     */
    public val dataSource: Output<String>
        get() = javaResource.dataSource().applyValue({ args0 -> args0 })

    /**
     * Function description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique ID representing the Function object.
     */
    public val functionId: Output<String>
        get() = javaResource.functionId().applyValue({ args0 -> args0 })

    /**
     * Version of the request mapping template. Currently the supported value is `2018-05-29`. Does not apply when specifying `code`.
     */
    public val functionVersion: Output<String>
        get() = javaResource.functionVersion().applyValue({ args0 -> args0 })

    /**
     * Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    public val maxBatchSize: Output<Int>?
        get() = javaResource.maxBatchSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Function name. The function name does not have to be unique.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
     */
    public val requestMappingTemplate: Output<String>?
        get() = javaResource.requestMappingTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Function response mapping template.
     */
    public val responseMappingTemplate: Output<String>?
        get() = javaResource.responseMappingTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See `runtime` Block for details.
     */
    public val runtime: Output<FunctionRuntime>?
        get() = javaResource.runtime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    functionRuntimeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes a Sync configuration for a resolver. See `sync_config` Block for details.
     */
    public val syncConfig: Output<FunctionSyncConfig>?
        get() = javaResource.syncConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    functionSyncConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object FunctionMapper : ResourceMapper<Function> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.Function::class == javaResource::class

    override fun map(javaResource: Resource): Function = Function(
        javaResource as
            com.pulumi.aws.appsync.Function,
    )
}

/**
 * @see [Function].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Function].
 */
public suspend fun function(name: String, block: suspend FunctionResourceBuilder.() -> Unit): Function {
    val builder = FunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Function].
 * @param name The _unique_ name of the resulting resource.
 */
public fun function(name: String): Function {
    val builder = FunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
