@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.FunctionArgs.builder
import com.pulumi.aws.appsync.kotlin.inputs.FunctionRuntimeArgs
import com.pulumi.aws.appsync.kotlin.inputs.FunctionRuntimeArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.FunctionSyncConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.FunctionSyncConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Function.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "example",
 *     schema: `type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 * `,
 * });
 * const exampleDataSource = new aws.appsync.DataSource("example", {
 *     apiId: example.id,
 *     name: "example",
 *     type: "HTTP",
 *     httpConfig: {
 *         endpoint: "http://example.com",
 *     },
 * });
 * const exampleFunction = new aws.appsync.Function("example", {
 *     apiId: example.id,
 *     dataSource: exampleDataSource.name,
 *     name: "example",
 *     requestMappingTemplate: `{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": utils.http.copyheaders(ctx.request.headers)
 *     }
 * }
 * `,
 *     responseMappingTemplate: `#if(ctx.result.statusCode == 200)
 *     ctx.result.body
 * #else
 *     utils.appendError(ctx.result.body, ctx.result.statusCode)
 * #end
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="example",
 *     schema="""type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 * """)
 * example_data_source = aws.appsync.DataSource("example",
 *     api_id=example.id,
 *     name="example",
 *     type="HTTP",
 *     http_config={
 *         "endpoint": "http://example.com",
 *     })
 * example_function = aws.appsync.Function("example",
 *     api_id=example.id,
 *     data_source=example_data_source.name,
 *     name="example",
 *     request_mapping_template="""{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * """,
 *     response_mapping_template="""#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "example",
 *         Schema = @"type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 * ",
 *     });
 *     var exampleDataSource = new Aws.AppSync.DataSource("example", new()
 *     {
 *         ApiId = example.Id,
 *         Name = "example",
 *         Type = "HTTP",
 *         HttpConfig = new Aws.AppSync.Inputs.DataSourceHttpConfigArgs
 *         {
 *             Endpoint = "http://example.com",
 *         },
 *     });
 *     var exampleFunction = new Aws.AppSync.Function("example", new()
 *     {
 *         ApiId = example.Id,
 *         DataSource = exampleDataSource.Name,
 *         Name = "example",
 *         RequestMappingTemplate = @"{
 *     ""version"": ""2018-05-29"",
 *     ""method"": ""GET"",
 *     ""resourcePath"": ""/"",
 *     ""params"":{
 *         ""headers"": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * ",
 *         ResponseMappingTemplate = @"#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("example"),
 * 			Schema: pulumi.String(`type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDataSource, err := appsync.NewDataSource(ctx, "example", &appsync.DataSourceArgs{
 * 			ApiId: example.ID(),
 * 			Name:  pulumi.String("example"),
 * 			Type:  pulumi.String("HTTP"),
 * 			HttpConfig: &appsync.DataSourceHttpConfigArgs{
 * 				Endpoint: pulumi.String("http://example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewFunction(ctx, "example", &appsync.FunctionArgs{
 * 			ApiId:      example.ID(),
 * 			DataSource: exampleDataSource.Name,
 * 			Name:       pulumi.String("example"),
 * 			RequestMappingTemplate: pulumi.String(`{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * `),
 * 			ResponseMappingTemplate: pulumi.String(`#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs;
 * import com.pulumi.aws.appsync.Function;
 * import com.pulumi.aws.appsync.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GraphQLApi("example", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("example")
 *             .schema("""
 * type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 *             """)
 *             .build());
 *         var exampleDataSource = new DataSource("exampleDataSource", DataSourceArgs.builder()
 *             .apiId(example.id())
 *             .name("example")
 *             .type("HTTP")
 *             .httpConfig(DataSourceHttpConfigArgs.builder()
 *                 .endpoint("http://example.com")
 *                 .build())
 *             .build());
 *         var exampleFunction = new Function("exampleFunction", FunctionArgs.builder()
 *             .apiId(example.id())
 *             .dataSource(exampleDataSource.name())
 *             .name("example")
 *             .requestMappingTemplate("""
 * {
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 *             """)
 *             .responseMappingTemplate("""
 * #if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: example
 *       schema: |
 *         type Mutation {
 *           putPost(id: ID!, title: String!): Post
 *         }
 *         type Post {
 *           id: ID!
 *           title: String!
 *         }
 *         type Query {
 *           singlePost(id: ID!): Post
 *         }
 *         schema {
 *           query: Query
 *           mutation: Mutation
 *         }
 *   exampleDataSource:
 *     type: aws:appsync:DataSource
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       name: example
 *       type: HTTP
 *       httpConfig:
 *         endpoint: http://example.com
 *   exampleFunction:
 *     type: aws:appsync:Function
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       dataSource: ${exampleDataSource.name}
 *       name: example
 *       requestMappingTemplate: |
 *         {
 *             "version": "2018-05-29",
 *             "method": "GET",
 *             "resourcePath": "/",
 *             "params":{
 *                 "headers": $utils.http.copyheaders($ctx.request.headers)
 *             }
 *         }
 *       responseMappingTemplate: |
 *         #if($ctx.result.statusCode == 200)
 *             $ctx.result.body
 *         #else
 *             $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 *         #end
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Code
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.appsync.Function("example", {
 *     apiId: exampleAwsAppsyncGraphqlApi.id,
 *     dataSource: exampleAwsAppsyncDatasource.name,
 *     name: "example",
 *     code: std.file({
 *         input: "some-code-dir",
 *     }).then(invoke => invoke.result),
 *     runtime: {
 *         name: "APPSYNC_JS",
 *         runtimeVersion: "1.0.0",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.appsync.Function("example",
 *     api_id=example_aws_appsync_graphql_api["id"],
 *     data_source=example_aws_appsync_datasource["name"],
 *     name="example",
 *     code=std.file(input="some-code-dir").result,
 *     runtime={
 *         "name": "APPSYNC_JS",
 *         "runtime_version": "1.0.0",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.Function("example", new()
 *     {
 *         ApiId = exampleAwsAppsyncGraphqlApi.Id,
 *         DataSource = exampleAwsAppsyncDatasource.Name,
 *         Name = "example",
 *         Code = Std.File.Invoke(new()
 *         {
 *             Input = "some-code-dir",
 *         }).Apply(invoke => invoke.Result),
 *         Runtime = new Aws.AppSync.Inputs.FunctionRuntimeArgs
 *         {
 *             Name = "APPSYNC_JS",
 *             RuntimeVersion = "1.0.0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "some-code-dir",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewFunction(ctx, "example", &appsync.FunctionArgs{
 * 			ApiId:      pulumi.Any(exampleAwsAppsyncGraphqlApi.Id),
 * 			DataSource: pulumi.Any(exampleAwsAppsyncDatasource.Name),
 * 			Name:       pulumi.String("example"),
 * 			Code:       pulumi.String(invokeFile.Result),
 * 			Runtime: &appsync.FunctionRuntimeArgs{
 * 				Name:           pulumi.String("APPSYNC_JS"),
 * 				RuntimeVersion: pulumi.String("1.0.0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.Function;
 * import com.pulumi.aws.appsync.FunctionArgs;
 * import com.pulumi.aws.appsync.inputs.FunctionRuntimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Function("example", FunctionArgs.builder()
 *             .apiId(exampleAwsAppsyncGraphqlApi.id())
 *             .dataSource(exampleAwsAppsyncDatasource.name())
 *             .name("example")
 *             .code(StdFunctions.file(FileArgs.builder()
 *                 .input("some-code-dir")
 *                 .build()).result())
 *             .runtime(FunctionRuntimeArgs.builder()
 *                 .name("APPSYNC_JS")
 *                 .runtimeVersion("1.0.0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:Function
 *     properties:
 *       apiId: ${exampleAwsAppsyncGraphqlApi.id}
 *       dataSource: ${exampleAwsAppsyncDatasource.name}
 *       name: example
 *       code:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: some-code-dir
 *           Return: result
 *       runtime:
 *         name: APPSYNC_JS
 *         runtimeVersion: 1.0.0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_function` using the AppSync API ID and Function ID separated by `-`. For example:
 * ```sh
 * $ pulumi import aws:appsync/function:Function example xxxxx-yyyyy
 * ```
 * @property apiId ID of the associated AppSync API.
 * @property code The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
 * @property dataSource Function data source name.
 * @property description Function description.
 * @property functionVersion Version of the request mapping template. Currently the supported value is `2018-05-29`. Does not apply when specifying `code`.
 * @property maxBatchSize Maximum batching size for a resolver. Valid values are between `0` and `2000`.
 * @property name Function name. The function name does not have to be unique.
 * @property requestMappingTemplate Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
 * @property responseMappingTemplate Function response mapping template.
 * @property runtime Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See `runtime` Block for details.
 * @property syncConfig Describes a Sync configuration for a resolver. See `sync_config` Block for details.
 */
public data class FunctionArgs(
    public val apiId: Output<String>? = null,
    public val code: Output<String>? = null,
    public val dataSource: Output<String>? = null,
    public val description: Output<String>? = null,
    public val functionVersion: Output<String>? = null,
    public val maxBatchSize: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val requestMappingTemplate: Output<String>? = null,
    public val responseMappingTemplate: Output<String>? = null,
    public val runtime: Output<FunctionRuntimeArgs>? = null,
    public val syncConfig: Output<FunctionSyncConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.FunctionArgs> {
    override fun toJava(): com.pulumi.aws.appsync.FunctionArgs =
        com.pulumi.aws.appsync.FunctionArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .code(code?.applyValue({ args0 -> args0 }))
            .dataSource(dataSource?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .functionVersion(functionVersion?.applyValue({ args0 -> args0 }))
            .maxBatchSize(maxBatchSize?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .requestMappingTemplate(requestMappingTemplate?.applyValue({ args0 -> args0 }))
            .responseMappingTemplate(responseMappingTemplate?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .syncConfig(syncConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FunctionArgs].
 */
@PulumiTagMarker
public class FunctionArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var code: Output<String>? = null

    private var dataSource: Output<String>? = null

    private var description: Output<String>? = null

    private var functionVersion: Output<String>? = null

    private var maxBatchSize: Output<Int>? = null

    private var name: Output<String>? = null

    private var requestMappingTemplate: Output<String>? = null

    private var responseMappingTemplate: Output<String>? = null

    private var runtime: Output<FunctionRuntimeArgs>? = null

    private var syncConfig: Output<FunctionSyncConfigArgs>? = null

    /**
     * @param value ID of the associated AppSync API.
     */
    @JvmName("yrgrdhgidkfxxlrp")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    @JvmName("batijfnccnxdriyv")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Function data source name.
     */
    @JvmName("gbptanvbhmrgxtou")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value Function description.
     */
    @JvmName("yyrgqfsgobetnqdn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Version of the request mapping template. Currently the supported value is `2018-05-29`. Does not apply when specifying `code`.
     */
    @JvmName("egvpyegrkoadeqvd")
    public suspend fun functionVersion(`value`: Output<String>) {
        this.functionVersion = value
    }

    /**
     * @param value Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    @JvmName("sjuqlgibjqnkarfx")
    public suspend fun maxBatchSize(`value`: Output<Int>) {
        this.maxBatchSize = value
    }

    /**
     * @param value Function name. The function name does not have to be unique.
     */
    @JvmName("lfidsqwewpcfwqnk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
     */
    @JvmName("xsjyseqtqduljlyl")
    public suspend fun requestMappingTemplate(`value`: Output<String>) {
        this.requestMappingTemplate = value
    }

    /**
     * @param value Function response mapping template.
     */
    @JvmName("qxbgxakwaxbbtllp")
    public suspend fun responseMappingTemplate(`value`: Output<String>) {
        this.responseMappingTemplate = value
    }

    /**
     * @param value Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See `runtime` Block for details.
     */
    @JvmName("kpbsdfydctclywsr")
    public suspend fun runtime(`value`: Output<FunctionRuntimeArgs>) {
        this.runtime = value
    }

    /**
     * @param value Describes a Sync configuration for a resolver. See `sync_config` Block for details.
     */
    @JvmName("qfhgsrhxjfsbhahy")
    public suspend fun syncConfig(`value`: Output<FunctionSyncConfigArgs>) {
        this.syncConfig = value
    }

    /**
     * @param value ID of the associated AppSync API.
     */
    @JvmName("qtsjlcrckvofshbd")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    @JvmName("gkrevdbsbdoqhnol")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Function data source name.
     */
    @JvmName("wqqkiqastfgidhug")
    public suspend fun dataSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value Function description.
     */
    @JvmName("oqdbupymwynddaiu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Version of the request mapping template. Currently the supported value is `2018-05-29`. Does not apply when specifying `code`.
     */
    @JvmName("xkyxxlybpjlcosdc")
    public suspend fun functionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionVersion = mapped
    }

    /**
     * @param value Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    @JvmName("yhppbrcqvgsodwui")
    public suspend fun maxBatchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBatchSize = mapped
    }

    /**
     * @param value Function name. The function name does not have to be unique.
     */
    @JvmName("mkipxicdhwgcvkii")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
     */
    @JvmName("biudgdbnolxewgdv")
    public suspend fun requestMappingTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMappingTemplate = mapped
    }

    /**
     * @param value Function response mapping template.
     */
    @JvmName("elabloprqsrldbhv")
    public suspend fun responseMappingTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseMappingTemplate = mapped
    }

    /**
     * @param value Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See `runtime` Block for details.
     */
    @JvmName("axtjghxmjknkktck")
    public suspend fun runtime(`value`: FunctionRuntimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param argument Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See `runtime` Block for details.
     */
    @JvmName("juorwbkfflpslanc")
    public suspend fun runtime(argument: suspend FunctionRuntimeArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionRuntimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runtime = mapped
    }

    /**
     * @param value Describes a Sync configuration for a resolver. See `sync_config` Block for details.
     */
    @JvmName("mvilmwdcjftxkdtb")
    public suspend fun syncConfig(`value`: FunctionSyncConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncConfig = mapped
    }

    /**
     * @param argument Describes a Sync configuration for a resolver. See `sync_config` Block for details.
     */
    @JvmName("bguyxawjelimriij")
    public suspend fun syncConfig(argument: suspend FunctionSyncConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionSyncConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.syncConfig = mapped
    }

    internal fun build(): FunctionArgs = FunctionArgs(
        apiId = apiId,
        code = code,
        dataSource = dataSource,
        description = description,
        functionVersion = functionVersion,
        maxBatchSize = maxBatchSize,
        name = name,
        requestMappingTemplate = requestMappingTemplate,
        responseMappingTemplate = responseMappingTemplate,
        runtime = runtime,
        syncConfig = syncConfig,
    )
}
