@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiAdditionalAuthenticationProvider
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiEnhancedMetricsConfig
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiLambdaAuthorizerConfig
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiLogConfig
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiOpenidConnectConfig
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiUserPoolConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiAdditionalAuthenticationProvider.Companion.toKotlin as graphQLApiAdditionalAuthenticationProviderToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiEnhancedMetricsConfig.Companion.toKotlin as graphQLApiEnhancedMetricsConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiLambdaAuthorizerConfig.Companion.toKotlin as graphQLApiLambdaAuthorizerConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiLogConfig.Companion.toKotlin as graphQLApiLogConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiOpenidConnectConfig.Companion.toKotlin as graphQLApiOpenidConnectConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiUserPoolConfig.Companion.toKotlin as graphQLApiUserPoolConfigToKotlin

/**
 * Builder for [GraphQLApi].
 */
@PulumiTagMarker
public class GraphQLApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GraphQLApiArgs = GraphQLApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GraphQLApiArgsBuilder.() -> Unit) {
        val builder = GraphQLApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GraphQLApi {
        val builtJavaResource = com.pulumi.aws.appsync.GraphQLApi(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GraphQLApi(builtJavaResource)
    }
}

public class GraphQLApi internal constructor(
    override val javaResource: com.pulumi.aws.appsync.GraphQLApi,
) : KotlinCustomResource(javaResource, GraphQLApiMapper) {
    /**
     * One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
     */
    public val additionalAuthenticationProviders:
        Output<List<GraphQLApiAdditionalAuthenticationProvider>>?
        get() = javaResource.additionalAuthenticationProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        graphQLApiAdditionalAuthenticationProviderToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
     */
    public val authenticationType: Output<String>
        get() = javaResource.authenticationType().applyValue({ args0 -> args0 })

    /**
     * Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
     */
    public val enhancedMetricsConfig: Output<GraphQLApiEnhancedMetricsConfig>?
        get() = javaResource.enhancedMetricsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> graphQLApiEnhancedMetricsConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
     */
    public val introspectionConfig: Output<String>?
        get() = javaResource.introspectionConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
     */
    public val lambdaAuthorizerConfig: Output<GraphQLApiLambdaAuthorizerConfig>?
        get() = javaResource.lambdaAuthorizerConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> graphQLApiLambdaAuthorizerConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Nested argument containing logging configuration. See `log_config` Block for details.
     */
    public val logConfig: Output<GraphQLApiLogConfig>?
        get() = javaResource.logConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    graphQLApiLogConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * User-supplied name for the GraphSQL API.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
     */
    public val openidConnectConfig: Output<GraphQLApiOpenidConnectConfig>?
        get() = javaResource.openidConnectConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> graphQLApiOpenidConnectConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
     * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
     */
    public val queryDepthLimit: Output<Int>?
        get() = javaResource.queryDepthLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
     */
    public val resolverCountLimit: Output<Int>?
        get() = javaResource.resolverCountLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
     */
    public val schema: Output<String>?
        get() = javaResource.schema().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Map of URIs associated with the APIE.g., `uris["GRAPHQL"] = https://ID.appsync-api.REGION.amazonaws.com/graphql`
     */
    public val uris: Output<Map<String, String>>
        get() = javaResource.uris().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
     */
    public val userPoolConfig: Output<GraphQLApiUserPoolConfig>?
        get() = javaResource.userPoolConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> graphQLApiUserPoolConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
     */
    public val visibility: Output<String>?
        get() = javaResource.visibility().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether tracing with X-ray is enabled. Defaults to false.
     */
    public val xrayEnabled: Output<Boolean>?
        get() = javaResource.xrayEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GraphQLApiMapper : ResourceMapper<GraphQLApi> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.GraphQLApi::class == javaResource::class

    override fun map(javaResource: Resource): GraphQLApi = GraphQLApi(
        javaResource as
            com.pulumi.aws.appsync.GraphQLApi,
    )
}

/**
 * @see [GraphQLApi].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GraphQLApi].
 */
public suspend fun graphQLApi(name: String, block: suspend GraphQLApiResourceBuilder.() -> Unit): GraphQLApi {
    val builder = GraphQLApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GraphQLApi].
 * @param name The _unique_ name of the resulting resource.
 */
public fun graphQLApi(name: String): GraphQLApi {
    val builder = GraphQLApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
