@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.GraphQLApiArgs.builder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiAdditionalAuthenticationProviderArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiAdditionalAuthenticationProviderArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiEnhancedMetricsConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiEnhancedMetricsConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiLambdaAuthorizerConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiLambdaAuthorizerConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiLogConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiLogConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiOpenidConnectConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiOpenidConnectConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiUserPoolConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiUserPoolConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property additionalAuthenticationProviders One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
 * @property authenticationType Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
 * @property enhancedMetricsConfig Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
 * @property introspectionConfig Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
 * @property lambdaAuthorizerConfig Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
 * @property logConfig Nested argument containing logging configuration. See `log_config` Block for details.
 * @property name User-supplied name for the GraphSQL API.
 * The following arguments are optional:
 * @property openidConnectConfig Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
 * @property queryDepthLimit The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
 * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
 * @property resolverCountLimit The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
 * @property schema Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userPoolConfig Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
 * @property visibility Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
 * @property xrayEnabled Whether tracing with X-ray is enabled. Defaults to false.
 */
public data class GraphQLApiArgs(
    public val additionalAuthenticationProviders: Output<List<GraphQLApiAdditionalAuthenticationProviderArgs>>? = null,
    public val authenticationType: Output<String>? = null,
    public val enhancedMetricsConfig: Output<GraphQLApiEnhancedMetricsConfigArgs>? = null,
    public val introspectionConfig: Output<String>? = null,
    public val lambdaAuthorizerConfig: Output<GraphQLApiLambdaAuthorizerConfigArgs>? = null,
    public val logConfig: Output<GraphQLApiLogConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val openidConnectConfig: Output<GraphQLApiOpenidConnectConfigArgs>? = null,
    public val queryDepthLimit: Output<Int>? = null,
    public val resolverCountLimit: Output<Int>? = null,
    public val schema: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userPoolConfig: Output<GraphQLApiUserPoolConfigArgs>? = null,
    public val visibility: Output<String>? = null,
    public val xrayEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.GraphQLApiArgs> {
    override fun toJava(): com.pulumi.aws.appsync.GraphQLApiArgs =
        com.pulumi.aws.appsync.GraphQLApiArgs.builder()
            .additionalAuthenticationProviders(
                additionalAuthenticationProviders?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .enhancedMetricsConfig(
                enhancedMetricsConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .introspectionConfig(introspectionConfig?.applyValue({ args0 -> args0 }))
            .lambdaAuthorizerConfig(
                lambdaAuthorizerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logConfig(logConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .openidConnectConfig(
                openidConnectConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .queryDepthLimit(queryDepthLimit?.applyValue({ args0 -> args0 }))
            .resolverCountLimit(resolverCountLimit?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userPoolConfig(userPoolConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .visibility(visibility?.applyValue({ args0 -> args0 }))
            .xrayEnabled(xrayEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiArgs].
 */
@PulumiTagMarker
public class GraphQLApiArgsBuilder internal constructor() {
    private var additionalAuthenticationProviders:
        Output<List<GraphQLApiAdditionalAuthenticationProviderArgs>>? = null

    private var authenticationType: Output<String>? = null

    private var enhancedMetricsConfig: Output<GraphQLApiEnhancedMetricsConfigArgs>? = null

    private var introspectionConfig: Output<String>? = null

    private var lambdaAuthorizerConfig: Output<GraphQLApiLambdaAuthorizerConfigArgs>? = null

    private var logConfig: Output<GraphQLApiLogConfigArgs>? = null

    private var name: Output<String>? = null

    private var openidConnectConfig: Output<GraphQLApiOpenidConnectConfigArgs>? = null

    private var queryDepthLimit: Output<Int>? = null

    private var resolverCountLimit: Output<Int>? = null

    private var schema: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userPoolConfig: Output<GraphQLApiUserPoolConfigArgs>? = null

    private var visibility: Output<String>? = null

    private var xrayEnabled: Output<Boolean>? = null

    /**
     * @param value One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
     */
    @JvmName("bhtvotbaghxkqgyk")
    public suspend fun additionalAuthenticationProviders(`value`: Output<List<GraphQLApiAdditionalAuthenticationProviderArgs>>) {
        this.additionalAuthenticationProviders = value
    }

    @JvmName("hqelpcdiyofibvki")
    public suspend fun additionalAuthenticationProviders(vararg values: Output<GraphQLApiAdditionalAuthenticationProviderArgs>) {
        this.additionalAuthenticationProviders = Output.all(values.asList())
    }

    /**
     * @param values One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
     */
    @JvmName("rlnwcsaoduytfcbf")
    public suspend fun additionalAuthenticationProviders(values: List<Output<GraphQLApiAdditionalAuthenticationProviderArgs>>) {
        this.additionalAuthenticationProviders = Output.all(values)
    }

    /**
     * @param value Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
     */
    @JvmName("jixiruufhhtcsanu")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
     */
    @JvmName("vsbydupjuatpyrau")
    public suspend fun enhancedMetricsConfig(`value`: Output<GraphQLApiEnhancedMetricsConfigArgs>) {
        this.enhancedMetricsConfig = value
    }

    /**
     * @param value Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
     */
    @JvmName("usrkfvprxpdfgjxo")
    public suspend fun introspectionConfig(`value`: Output<String>) {
        this.introspectionConfig = value
    }

    /**
     * @param value Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
     */
    @JvmName("ojtpcfmhlxwhsfum")
    public suspend fun lambdaAuthorizerConfig(`value`: Output<GraphQLApiLambdaAuthorizerConfigArgs>) {
        this.lambdaAuthorizerConfig = value
    }

    /**
     * @param value Nested argument containing logging configuration. See `log_config` Block for details.
     */
    @JvmName("ifyhkbvodhbqawxm")
    public suspend fun logConfig(`value`: Output<GraphQLApiLogConfigArgs>) {
        this.logConfig = value
    }

    /**
     * @param value User-supplied name for the GraphSQL API.
     * The following arguments are optional:
     */
    @JvmName("irffvfbbhljbeykf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
     */
    @JvmName("ppefujrlcrwoclaf")
    public suspend fun openidConnectConfig(`value`: Output<GraphQLApiOpenidConnectConfigArgs>) {
        this.openidConnectConfig = value
    }

    /**
     * @param value The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
     * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
     */
    @JvmName("spivtnokvyyiajse")
    public suspend fun queryDepthLimit(`value`: Output<Int>) {
        this.queryDepthLimit = value
    }

    /**
     * @param value The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
     */
    @JvmName("paxpwsutstdymjhk")
    public suspend fun resolverCountLimit(`value`: Output<Int>) {
        this.resolverCountLimit = value
    }

    /**
     * @param value Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
     */
    @JvmName("nakkbgtpeyeracdl")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mhbolvpjjcsowqtv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
     */
    @JvmName("ddkgfhjumyrvwqse")
    public suspend fun userPoolConfig(`value`: Output<GraphQLApiUserPoolConfigArgs>) {
        this.userPoolConfig = value
    }

    /**
     * @param value Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
     */
    @JvmName("wiisunctanbenjvq")
    public suspend fun visibility(`value`: Output<String>) {
        this.visibility = value
    }

    /**
     * @param value Whether tracing with X-ray is enabled. Defaults to false.
     */
    @JvmName("knhmaqvedtxbmjpu")
    public suspend fun xrayEnabled(`value`: Output<Boolean>) {
        this.xrayEnabled = value
    }

    /**
     * @param value One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
     */
    @JvmName("junhdakrwccspxdh")
    public suspend fun additionalAuthenticationProviders(`value`: List<GraphQLApiAdditionalAuthenticationProviderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param argument One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
     */
    @JvmName("awwcdpxxarqxggsh")
    public suspend fun additionalAuthenticationProviders(argument: List<suspend GraphQLApiAdditionalAuthenticationProviderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GraphQLApiAdditionalAuthenticationProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param argument One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
     */
    @JvmName("qlakbxutfoyilemx")
    public suspend fun additionalAuthenticationProviders(vararg argument: suspend GraphQLApiAdditionalAuthenticationProviderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GraphQLApiAdditionalAuthenticationProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param argument One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
     */
    @JvmName("fauebfrmvguwvcdg")
    public suspend fun additionalAuthenticationProviders(argument: suspend GraphQLApiAdditionalAuthenticationProviderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GraphQLApiAdditionalAuthenticationProviderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param values One or more additional authentication providers for the GraphSQL API. See `additional_authentication_provider` Block for details.
     */
    @JvmName("naaojxlsxjucysif")
    public suspend fun additionalAuthenticationProviders(vararg values: GraphQLApiAdditionalAuthenticationProviderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param value Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
     */
    @JvmName("qdwtnidjayxcukca")
    public suspend fun authenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
     */
    @JvmName("qlbhedmdarltgnwk")
    public suspend fun enhancedMetricsConfig(`value`: GraphQLApiEnhancedMetricsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedMetricsConfig = mapped
    }

    /**
     * @param argument Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
     */
    @JvmName("suhrwwhbhsgwkpok")
    public suspend fun enhancedMetricsConfig(argument: suspend GraphQLApiEnhancedMetricsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiEnhancedMetricsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enhancedMetricsConfig = mapped
    }

    /**
     * @param value Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
     */
    @JvmName("blplespbtwqhykaf")
    public suspend fun introspectionConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.introspectionConfig = mapped
    }

    /**
     * @param value Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
     */
    @JvmName("gfxaavmgvpggraoo")
    public suspend fun lambdaAuthorizerConfig(`value`: GraphQLApiLambdaAuthorizerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaAuthorizerConfig = mapped
    }

    /**
     * @param argument Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
     */
    @JvmName("gfkpsisfcnggdcix")
    public suspend fun lambdaAuthorizerConfig(argument: suspend GraphQLApiLambdaAuthorizerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiLambdaAuthorizerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lambdaAuthorizerConfig = mapped
    }

    /**
     * @param value Nested argument containing logging configuration. See `log_config` Block for details.
     */
    @JvmName("fdmonxubwbwsrkra")
    public suspend fun logConfig(`value`: GraphQLApiLogConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfig = mapped
    }

    /**
     * @param argument Nested argument containing logging configuration. See `log_config` Block for details.
     */
    @JvmName("pjoqfvlaotnjudec")
    public suspend fun logConfig(argument: suspend GraphQLApiLogConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiLogConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logConfig = mapped
    }

    /**
     * @param value User-supplied name for the GraphSQL API.
     * The following arguments are optional:
     */
    @JvmName("gfnbymrxespfiupy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
     */
    @JvmName("xmvpxjekmvcisnst")
    public suspend fun openidConnectConfig(`value`: GraphQLApiOpenidConnectConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openidConnectConfig = mapped
    }

    /**
     * @param argument Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
     */
    @JvmName("wsyybikksfujvyuk")
    public suspend fun openidConnectConfig(argument: suspend GraphQLApiOpenidConnectConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiOpenidConnectConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.openidConnectConfig = mapped
    }

    /**
     * @param value The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
     * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
     */
    @JvmName("okrhwnnbslyhkixa")
    public suspend fun queryDepthLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryDepthLimit = mapped
    }

    /**
     * @param value The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
     */
    @JvmName("lyogjsronkqndmql")
    public suspend fun resolverCountLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolverCountLimit = mapped
    }

    /**
     * @param value Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
     */
    @JvmName("nfscgvxjmdpnhsjs")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bkiahmmfmxscqbgq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("usdkcpssqrccxywp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
     */
    @JvmName("wmhgydssoctvprur")
    public suspend fun userPoolConfig(`value`: GraphQLApiUserPoolConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolConfig = mapped
    }

    /**
     * @param argument Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
     */
    @JvmName("hxshhcydkyletkmn")
    public suspend fun userPoolConfig(argument: suspend GraphQLApiUserPoolConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiUserPoolConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userPoolConfig = mapped
    }

    /**
     * @param value Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
     */
    @JvmName("iuydptgjplduhqrn")
    public suspend fun visibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param value Whether tracing with X-ray is enabled. Defaults to false.
     */
    @JvmName("bsmesblcgskeadqc")
    public suspend fun xrayEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xrayEnabled = mapped
    }

    internal fun build(): GraphQLApiArgs = GraphQLApiArgs(
        additionalAuthenticationProviders = additionalAuthenticationProviders,
        authenticationType = authenticationType,
        enhancedMetricsConfig = enhancedMetricsConfig,
        introspectionConfig = introspectionConfig,
        lambdaAuthorizerConfig = lambdaAuthorizerConfig,
        logConfig = logConfig,
        name = name,
        openidConnectConfig = openidConnectConfig,
        queryDepthLimit = queryDepthLimit,
        resolverCountLimit = resolverCountLimit,
        schema = schema,
        tags = tags,
        userPoolConfig = userPoolConfig,
        visibility = visibility,
        xrayEnabled = xrayEnabled,
    )
}
