@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.kotlin.outputs.ResolverCachingConfig
import com.pulumi.aws.appsync.kotlin.outputs.ResolverPipelineConfig
import com.pulumi.aws.appsync.kotlin.outputs.ResolverRuntime
import com.pulumi.aws.appsync.kotlin.outputs.ResolverSyncConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.appsync.kotlin.outputs.ResolverCachingConfig.Companion.toKotlin as resolverCachingConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.ResolverPipelineConfig.Companion.toKotlin as resolverPipelineConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.ResolverRuntime.Companion.toKotlin as resolverRuntimeToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.ResolverSyncConfig.Companion.toKotlin as resolverSyncConfigToKotlin

/**
 * Builder for [Resolver].
 */
@PulumiTagMarker
public class ResolverResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverArgs = ResolverArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverArgsBuilder.() -> Unit) {
        val builder = ResolverArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Resolver {
        val builtJavaResource = com.pulumi.aws.appsync.Resolver(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Resolver(builtJavaResource)
    }
}

/**
 * Provides an AppSync Resolver.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.appsync.GraphQLApi("test", {
 *     authenticationType: "API_KEY",
 *     name: "tf-example",
 *     schema: `type Mutation {
 * \x09putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * \x09id: ID!
 * \x09title: String!
 * }
 * type Query {
 * \x09singlePost(id: ID!): Post
 * }
 * schema {
 * \x09query: Query
 * \x09mutation: Mutation
 * }
 * `,
 * });
 * const testDataSource = new aws.appsync.DataSource("test", {
 *     apiId: test.id,
 *     name: "my_example",
 *     type: "HTTP",
 *     httpConfig: {
 *         endpoint: "http://example.com",
 *     },
 * });
 * // UNIT type resolver (default)
 * const testResolver = new aws.appsync.Resolver("test", {
 *     apiId: test.id,
 *     field: "singlePost",
 *     type: "Query",
 *     dataSource: testDataSource.name,
 *     requestTemplate: `{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": utils.http.copyheaders(ctx.request.headers)
 *     }
 * }
 * `,
 *     responseTemplate: `#if(ctx.result.statusCode == 200)
 *     ctx.result.body
 * #else
 *     utils.appendError(ctx.result.body, ctx.result.statusCode)
 * #end
 * `,
 *     cachingConfig: {
 *         cachingKeys: [
 *             "$context.identity.sub",
 *             "$context.arguments.id",
 *         ],
 *         ttl: 60,
 *     },
 * });
 * // PIPELINE type resolver
 * const mutationPipelineTest = new aws.appsync.Resolver("Mutation_pipelineTest", {
 *     type: "Mutation",
 *     apiId: test.id,
 *     field: "pipelineTest",
 *     requestTemplate: "{}",
 *     responseTemplate: "$util.toJson($ctx.result)",
 *     kind: "PIPELINE",
 *     pipelineConfig: {
 *         functions: [
 *             test1.functionId,
 *             test2.functionId,
 *             test3.functionId,
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.appsync.GraphQLApi("test",
 *     authentication_type="API_KEY",
 *     name="tf-example",
 *     schema="""type Mutation {
 * \x09putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * \x09id: ID!
 * \x09title: String!
 * }
 * type Query {
 * \x09singlePost(id: ID!): Post
 * }
 * schema {
 * \x09query: Query
 * \x09mutation: Mutation
 * }
 * """)
 * test_data_source = aws.appsync.DataSource("test",
 *     api_id=test.id,
 *     name="my_example",
 *     type="HTTP",
 *     http_config={
 *         "endpoint": "http://example.com",
 *     })
 * # UNIT type resolver (default)
 * test_resolver = aws.appsync.Resolver("test",
 *     api_id=test.id,
 *     field="singlePost",
 *     type="Query",
 *     data_source=test_data_source.name,
 *     request_template="""{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * """,
 *     response_template="""#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * """,
 *     caching_config={
 *         "caching_keys": [
 *             "$context.identity.sub",
 *             "$context.arguments.id",
 *         ],
 *         "ttl": 60,
 *     })
 * # PIPELINE type resolver
 * mutation_pipeline_test = aws.appsync.Resolver("Mutation_pipelineTest",
 *     type="Mutation",
 *     api_id=test.id,
 *     field="pipelineTest",
 *     request_template="{}",
 *     response_template="$util.toJson($ctx.result)",
 *     kind="PIPELINE",
 *     pipeline_config={
 *         "functions": [
 *             test1["functionId"],
 *             test2["functionId"],
 *             test3["functionId"],
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.AppSync.GraphQLApi("test", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "tf-example",
 *         Schema = @"type Mutation {
 * 	putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * 	id: ID!
 * 	title: String!
 * }
 * type Query {
 * 	singlePost(id: ID!): Post
 * }
 * schema {
 * 	query: Query
 * 	mutation: Mutation
 * }
 * ",
 *     });
 *     var testDataSource = new Aws.AppSync.DataSource("test", new()
 *     {
 *         ApiId = test.Id,
 *         Name = "my_example",
 *         Type = "HTTP",
 *         HttpConfig = new Aws.AppSync.Inputs.DataSourceHttpConfigArgs
 *         {
 *             Endpoint = "http://example.com",
 *         },
 *     });
 *     // UNIT type resolver (default)
 *     var testResolver = new Aws.AppSync.Resolver("test", new()
 *     {
 *         ApiId = test.Id,
 *         Field = "singlePost",
 *         Type = "Query",
 *         DataSource = testDataSource.Name,
 *         RequestTemplate = @"{
 *     ""version"": ""2018-05-29"",
 *     ""method"": ""GET"",
 *     ""resourcePath"": ""/"",
 *     ""params"":{
 *         ""headers"": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * ",
 *         ResponseTemplate = @"#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * ",
 *         CachingConfig = new Aws.AppSync.Inputs.ResolverCachingConfigArgs
 *         {
 *             CachingKeys = new[]
 *             {
 *                 "$context.identity.sub",
 *                 "$context.arguments.id",
 *             },
 *             Ttl = 60,
 *         },
 *     });
 *     // PIPELINE type resolver
 *     var mutationPipelineTest = new Aws.AppSync.Resolver("Mutation_pipelineTest", new()
 *     {
 *         Type = "Mutation",
 *         ApiId = test.Id,
 *         Field = "pipelineTest",
 *         RequestTemplate = "{}",
 *         ResponseTemplate = "$util.toJson($ctx.result)",
 *         Kind = "PIPELINE",
 *         PipelineConfig = new Aws.AppSync.Inputs.ResolverPipelineConfigArgs
 *         {
 *             Functions = new[]
 *             {
 *                 test1.FunctionId,
 *                 test2.FunctionId,
 *                 test3.FunctionId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := appsync.NewGraphQLApi(ctx, "test", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("tf-example"),
 * 			Schema: pulumi.String(`type Mutation {
 * 	putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * 	id: ID!
 * 	title: String!
 * }
 * type Query {
 * 	singlePost(id: ID!): Post
 * }
 * schema {
 * 	query: Query
 * 	mutation: Mutation
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testDataSource, err := appsync.NewDataSource(ctx, "test", &appsync.DataSourceArgs{
 * 			ApiId: test.ID(),
 * 			Name:  pulumi.String("my_example"),
 * 			Type:  pulumi.String("HTTP"),
 * 			HttpConfig: &appsync.DataSourceHttpConfigArgs{
 * 				Endpoint: pulumi.String("http://example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// UNIT type resolver (default)
 * 		_, err = appsync.NewResolver(ctx, "test", &appsync.ResolverArgs{
 * 			ApiId:      test.ID(),
 * 			Field:      pulumi.String("singlePost"),
 * 			Type:       pulumi.String("Query"),
 * 			DataSource: testDataSource.Name,
 * 			RequestTemplate: pulumi.String(`{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * `),
 * 			ResponseTemplate: pulumi.String(`#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * `),
 * 			CachingConfig: &appsync.ResolverCachingConfigArgs{
 * 				CachingKeys: pulumi.StringArray{
 * 					pulumi.String("$context.identity.sub"),
 * 					pulumi.String("$context.arguments.id"),
 * 				},
 * 				Ttl: pulumi.Int(60),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// PIPELINE type resolver
 * 		_, err = appsync.NewResolver(ctx, "Mutation_pipelineTest", &appsync.ResolverArgs{
 * 			Type:             pulumi.String("Mutation"),
 * 			ApiId:            test.ID(),
 * 			Field:            pulumi.String("pipelineTest"),
 * 			RequestTemplate:  pulumi.String("{}"),
 * 			ResponseTemplate: pulumi.String("$util.toJson($ctx.result)"),
 * 			Kind:             pulumi.String("PIPELINE"),
 * 			PipelineConfig: &appsync.ResolverPipelineConfigArgs{
 * 				Functions: pulumi.StringArray{
 * 					test1.FunctionId,
 * 					test2.FunctionId,
 * 					test3.FunctionId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs;
 * import com.pulumi.aws.appsync.Resolver;
 * import com.pulumi.aws.appsync.ResolverArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverCachingConfigArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GraphQLApi("test", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("tf-example")
 *             .schema("""
 * type Mutation {
 * 	putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * 	id: ID!
 * 	title: String!
 * }
 * type Query {
 * 	singlePost(id: ID!): Post
 * }
 * schema {
 * 	query: Query
 * 	mutation: Mutation
 * }
 *             """)
 *             .build());
 *         var testDataSource = new DataSource("testDataSource", DataSourceArgs.builder()
 *             .apiId(test.id())
 *             .name("my_example")
 *             .type("HTTP")
 *             .httpConfig(DataSourceHttpConfigArgs.builder()
 *                 .endpoint("http://example.com")
 *                 .build())
 *             .build());
 *         // UNIT type resolver (default)
 *         var testResolver = new Resolver("testResolver", ResolverArgs.builder()
 *             .apiId(test.id())
 *             .field("singlePost")
 *             .type("Query")
 *             .dataSource(testDataSource.name())
 *             .requestTemplate("""
 * {
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 *             """)
 *             .responseTemplate("""
 * #if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 *             """)
 *             .cachingConfig(ResolverCachingConfigArgs.builder()
 *                 .cachingKeys(
 *                     "$context.identity.sub",
 *                     "$context.arguments.id")
 *                 .ttl(60)
 *                 .build())
 *             .build());
 *         // PIPELINE type resolver
 *         var mutationPipelineTest = new Resolver("mutationPipelineTest", ResolverArgs.builder()
 *             .type("Mutation")
 *             .apiId(test.id())
 *             .field("pipelineTest")
 *             .requestTemplate("{}")
 *             .responseTemplate("$util.toJson($ctx.result)")
 *             .kind("PIPELINE")
 *             .pipelineConfig(ResolverPipelineConfigArgs.builder()
 *                 .functions(
 *                     test1.functionId(),
 *                     test2.functionId(),
 *                     test3.functionId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: tf-example
 *       schema: |
 *         type Mutation {
 *         	putPost(id: ID!, title: String!): Post
 *         }
 *         type Post {
 *         	id: ID!
 *         	title: String!
 *         }
 *         type Query {
 *         	singlePost(id: ID!): Post
 *         }
 *         schema {
 *         	query: Query
 *         	mutation: Mutation
 *         }
 *   testDataSource:
 *     type: aws:appsync:DataSource
 *     name: test
 *     properties:
 *       apiId: ${test.id}
 *       name: my_example
 *       type: HTTP
 *       httpConfig:
 *         endpoint: http://example.com
 *   # UNIT type resolver (default)
 *   testResolver:
 *     type: aws:appsync:Resolver
 *     name: test
 *     properties:
 *       apiId: ${test.id}
 *       field: singlePost
 *       type: Query
 *       dataSource: ${testDataSource.name}
 *       requestTemplate: |
 *         {
 *             "version": "2018-05-29",
 *             "method": "GET",
 *             "resourcePath": "/",
 *             "params":{
 *                 "headers": $utils.http.copyheaders($ctx.request.headers)
 *             }
 *         }
 *       responseTemplate: |
 *         #if($ctx.result.statusCode == 200)
 *             $ctx.result.body
 *         #else
 *             $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 *         #end
 *       cachingConfig:
 *         cachingKeys:
 *           - $context.identity.sub
 *           - $context.arguments.id
 *         ttl: 60
 *   # PIPELINE type resolver
 *   mutationPipelineTest:
 *     type: aws:appsync:Resolver
 *     name: Mutation_pipelineTest
 *     properties:
 *       type: Mutation
 *       apiId: ${test.id}
 *       field: pipelineTest
 *       requestTemplate: '{}'
 *       responseTemplate: $util.toJson($ctx.result)
 *       kind: PIPELINE
 *       pipelineConfig:
 *         functions:
 *           - ${test1.functionId}
 *           - ${test2.functionId}
 *           - ${test3.functionId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### JS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.appsync.Resolver("example", {
 *     type: "Query",
 *     apiId: testAwsAppsyncGraphqlApi.id,
 *     field: "pipelineTest",
 *     kind: "PIPELINE",
 *     code: std.file({
 *         input: "some-code-dir",
 *     }).then(invoke => invoke.result),
 *     runtime: {
 *         name: "APPSYNC_JS",
 *         runtimeVersion: "1.0.0",
 *     },
 *     pipelineConfig: {
 *         functions: [test&#46;functionId],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.appsync.Resolver("example",
 *     type="Query",
 *     api_id=test_aws_appsync_graphql_api["id"],
 *     field="pipelineTest",
 *     kind="PIPELINE",
 *     code=std.file(input="some-code-dir").result,
 *     runtime={
 *         "name": "APPSYNC_JS",
 *         "runtime_version": "1.0.0",
 *     },
 *     pipeline_config={
 *         "functions": [test["functionId"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.Resolver("example", new()
 *     {
 *         Type = "Query",
 *         ApiId = testAwsAppsyncGraphqlApi.Id,
 *         Field = "pipelineTest",
 *         Kind = "PIPELINE",
 *         Code = Std.File.Invoke(new()
 *         {
 *             Input = "some-code-dir",
 *         }).Apply(invoke => invoke.Result),
 *         Runtime = new Aws.AppSync.Inputs.ResolverRuntimeArgs
 *         {
 *             Name = "APPSYNC_JS",
 *             RuntimeVersion = "1.0.0",
 *         },
 *         PipelineConfig = new Aws.AppSync.Inputs.ResolverPipelineConfigArgs
 *         {
 *             Functions = new[]
 *             {
 *                 test.FunctionId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "some-code-dir",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewResolver(ctx, "example", &appsync.ResolverArgs{
 * 			Type:  pulumi.String("Query"),
 * 			ApiId: pulumi.Any(testAwsAppsyncGraphqlApi.Id),
 * 			Field: pulumi.String("pipelineTest"),
 * 			Kind:  pulumi.String("PIPELINE"),
 * 			Code:  pulumi.String(invokeFile.Result),
 * 			Runtime: &appsync.ResolverRuntimeArgs{
 * 				Name:           pulumi.String("APPSYNC_JS"),
 * 				RuntimeVersion: pulumi.String("1.0.0"),
 * 			},
 * 			PipelineConfig: &appsync.ResolverPipelineConfigArgs{
 * 				Functions: pulumi.StringArray{
 * 					test.FunctionId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.Resolver;
 * import com.pulumi.aws.appsync.ResolverArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverRuntimeArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resolver("example", ResolverArgs.builder()
 *             .type("Query")
 *             .apiId(testAwsAppsyncGraphqlApi.id())
 *             .field("pipelineTest")
 *             .kind("PIPELINE")
 *             .code(StdFunctions.file(FileArgs.builder()
 *                 .input("some-code-dir")
 *                 .build()).result())
 *             .runtime(ResolverRuntimeArgs.builder()
 *                 .name("APPSYNC_JS")
 *                 .runtimeVersion("1.0.0")
 *                 .build())
 *             .pipelineConfig(ResolverPipelineConfigArgs.builder()
 *                 .functions(test.functionId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:Resolver
 *     properties:
 *       type: Query
 *       apiId: ${testAwsAppsyncGraphqlApi.id}
 *       field: pipelineTest
 *       kind: PIPELINE
 *       code:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: some-code-dir
 *           Return: result
 *       runtime:
 *         name: APPSYNC_JS
 *         runtimeVersion: 1.0.0
 *       pipelineConfig:
 *         functions:
 *           - ${test.functionId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_resolver` using the `api_id`, a hyphen, `type`, a hypen and `field`. For example:
 * ```sh
 * $ pulumi import aws:appsync/resolver:Resolver example abcdef123456-exampleType-exampleField
 * ```
 */
public class Resolver internal constructor(
    override val javaResource: com.pulumi.aws.appsync.Resolver,
) : KotlinCustomResource(javaResource, ResolverMapper) {
    /**
     * API ID for the GraphQL API.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Caching Config. See Caching Config.
     */
    public val cachingConfig: Output<ResolverCachingConfig>?
        get() = javaResource.cachingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resolverCachingConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    public val code: Output<String>?
        get() = javaResource.code().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Data source name.
     */
    public val dataSource: Output<String>?
        get() = javaResource.dataSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field name from the schema defined in the GraphQL API.
     */
    public val `field`: Output<String>
        get() = javaResource.`field`().applyValue({ args0 -> args0 })

    /**
     * Resolver type. Valid values are `UNIT` and `PIPELINE`.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    public val maxBatchSize: Output<Int>?
        get() = javaResource.maxBatchSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The caching configuration for the resolver. See Pipeline Config.
     */
    public val pipelineConfig: Output<ResolverPipelineConfig>?
        get() = javaResource.pipelineConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resolverPipelineConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    public val requestTemplate: Output<String>?
        get() = javaResource.requestTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    public val responseTemplate: Output<String>?
        get() = javaResource.responseTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    public val runtime: Output<ResolverRuntime>?
        get() = javaResource.runtime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resolverRuntimeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes a Sync configuration for a resolver. See Sync Config.
     */
    public val syncConfig: Output<ResolverSyncConfig>?
        get() = javaResource.syncConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resolverSyncConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type name from the schema defined in the GraphQL API.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResolverMapper : ResourceMapper<Resolver> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.Resolver::class == javaResource::class

    override fun map(javaResource: Resource): Resolver = Resolver(
        javaResource as
            com.pulumi.aws.appsync.Resolver,
    )
}

/**
 * @see [Resolver].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Resolver].
 */
public suspend fun resolver(name: String, block: suspend ResolverResourceBuilder.() -> Unit): Resolver {
    val builder = ResolverResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Resolver].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolver(name: String): Resolver {
    val builder = ResolverResourceBuilder()
    builder.name(name)
    return builder.build()
}
