@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.ResolverArgs.builder
import com.pulumi.aws.appsync.kotlin.inputs.ResolverCachingConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.ResolverCachingConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.ResolverPipelineConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.ResolverPipelineConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.ResolverRuntimeArgs
import com.pulumi.aws.appsync.kotlin.inputs.ResolverRuntimeArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.ResolverSyncConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.ResolverSyncConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Resolver.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.appsync.GraphQLApi("test", {
 *     authenticationType: "API_KEY",
 *     name: "tf-example",
 *     schema: `type Mutation {
 * \x09putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * \x09id: ID!
 * \x09title: String!
 * }
 * type Query {
 * \x09singlePost(id: ID!): Post
 * }
 * schema {
 * \x09query: Query
 * \x09mutation: Mutation
 * }
 * `,
 * });
 * const testDataSource = new aws.appsync.DataSource("test", {
 *     apiId: test.id,
 *     name: "my_example",
 *     type: "HTTP",
 *     httpConfig: {
 *         endpoint: "http://example.com",
 *     },
 * });
 * // UNIT type resolver (default)
 * const testResolver = new aws.appsync.Resolver("test", {
 *     apiId: test.id,
 *     field: "singlePost",
 *     type: "Query",
 *     dataSource: testDataSource.name,
 *     requestTemplate: `{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": utils.http.copyheaders(ctx.request.headers)
 *     }
 * }
 * `,
 *     responseTemplate: `#if(ctx.result.statusCode == 200)
 *     ctx.result.body
 * #else
 *     utils.appendError(ctx.result.body, ctx.result.statusCode)
 * #end
 * `,
 *     cachingConfig: {
 *         cachingKeys: [
 *             "$context.identity.sub",
 *             "$context.arguments.id",
 *         ],
 *         ttl: 60,
 *     },
 * });
 * // PIPELINE type resolver
 * const mutationPipelineTest = new aws.appsync.Resolver("Mutation_pipelineTest", {
 *     type: "Mutation",
 *     apiId: test.id,
 *     field: "pipelineTest",
 *     requestTemplate: "{}",
 *     responseTemplate: "$util.toJson($ctx.result)",
 *     kind: "PIPELINE",
 *     pipelineConfig: {
 *         functions: [
 *             test1.functionId,
 *             test2.functionId,
 *             test3.functionId,
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.appsync.GraphQLApi("test",
 *     authentication_type="API_KEY",
 *     name="tf-example",
 *     schema="""type Mutation {
 * \x09putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * \x09id: ID!
 * \x09title: String!
 * }
 * type Query {
 * \x09singlePost(id: ID!): Post
 * }
 * schema {
 * \x09query: Query
 * \x09mutation: Mutation
 * }
 * """)
 * test_data_source = aws.appsync.DataSource("test",
 *     api_id=test.id,
 *     name="my_example",
 *     type="HTTP",
 *     http_config={
 *         "endpoint": "http://example.com",
 *     })
 * # UNIT type resolver (default)
 * test_resolver = aws.appsync.Resolver("test",
 *     api_id=test.id,
 *     field="singlePost",
 *     type="Query",
 *     data_source=test_data_source.name,
 *     request_template="""{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * """,
 *     response_template="""#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * """,
 *     caching_config={
 *         "caching_keys": [
 *             "$context.identity.sub",
 *             "$context.arguments.id",
 *         ],
 *         "ttl": 60,
 *     })
 * # PIPELINE type resolver
 * mutation_pipeline_test = aws.appsync.Resolver("Mutation_pipelineTest",
 *     type="Mutation",
 *     api_id=test.id,
 *     field="pipelineTest",
 *     request_template="{}",
 *     response_template="$util.toJson($ctx.result)",
 *     kind="PIPELINE",
 *     pipeline_config={
 *         "functions": [
 *             test1["functionId"],
 *             test2["functionId"],
 *             test3["functionId"],
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.AppSync.GraphQLApi("test", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "tf-example",
 *         Schema = @"type Mutation {
 * 	putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * 	id: ID!
 * 	title: String!
 * }
 * type Query {
 * 	singlePost(id: ID!): Post
 * }
 * schema {
 * 	query: Query
 * 	mutation: Mutation
 * }
 * ",
 *     });
 *     var testDataSource = new Aws.AppSync.DataSource("test", new()
 *     {
 *         ApiId = test.Id,
 *         Name = "my_example",
 *         Type = "HTTP",
 *         HttpConfig = new Aws.AppSync.Inputs.DataSourceHttpConfigArgs
 *         {
 *             Endpoint = "http://example.com",
 *         },
 *     });
 *     // UNIT type resolver (default)
 *     var testResolver = new Aws.AppSync.Resolver("test", new()
 *     {
 *         ApiId = test.Id,
 *         Field = "singlePost",
 *         Type = "Query",
 *         DataSource = testDataSource.Name,
 *         RequestTemplate = @"{
 *     ""version"": ""2018-05-29"",
 *     ""method"": ""GET"",
 *     ""resourcePath"": ""/"",
 *     ""params"":{
 *         ""headers"": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * ",
 *         ResponseTemplate = @"#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * ",
 *         CachingConfig = new Aws.AppSync.Inputs.ResolverCachingConfigArgs
 *         {
 *             CachingKeys = new[]
 *             {
 *                 "$context.identity.sub",
 *                 "$context.arguments.id",
 *             },
 *             Ttl = 60,
 *         },
 *     });
 *     // PIPELINE type resolver
 *     var mutationPipelineTest = new Aws.AppSync.Resolver("Mutation_pipelineTest", new()
 *     {
 *         Type = "Mutation",
 *         ApiId = test.Id,
 *         Field = "pipelineTest",
 *         RequestTemplate = "{}",
 *         ResponseTemplate = "$util.toJson($ctx.result)",
 *         Kind = "PIPELINE",
 *         PipelineConfig = new Aws.AppSync.Inputs.ResolverPipelineConfigArgs
 *         {
 *             Functions = new[]
 *             {
 *                 test1.FunctionId,
 *                 test2.FunctionId,
 *                 test3.FunctionId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := appsync.NewGraphQLApi(ctx, "test", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("tf-example"),
 * 			Schema: pulumi.String(`type Mutation {
 * 	putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * 	id: ID!
 * 	title: String!
 * }
 * type Query {
 * 	singlePost(id: ID!): Post
 * }
 * schema {
 * 	query: Query
 * 	mutation: Mutation
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testDataSource, err := appsync.NewDataSource(ctx, "test", &appsync.DataSourceArgs{
 * 			ApiId: test.ID(),
 * 			Name:  pulumi.String("my_example"),
 * 			Type:  pulumi.String("HTTP"),
 * 			HttpConfig: &appsync.DataSourceHttpConfigArgs{
 * 				Endpoint: pulumi.String("http://example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// UNIT type resolver (default)
 * 		_, err = appsync.NewResolver(ctx, "test", &appsync.ResolverArgs{
 * 			ApiId:      test.ID(),
 * 			Field:      pulumi.String("singlePost"),
 * 			Type:       pulumi.String("Query"),
 * 			DataSource: testDataSource.Name,
 * 			RequestTemplate: pulumi.String(`{
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 * `),
 * 			ResponseTemplate: pulumi.String(`#if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 * `),
 * 			CachingConfig: &appsync.ResolverCachingConfigArgs{
 * 				CachingKeys: pulumi.StringArray{
 * 					pulumi.String("$context.identity.sub"),
 * 					pulumi.String("$context.arguments.id"),
 * 				},
 * 				Ttl: pulumi.Int(60),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// PIPELINE type resolver
 * 		_, err = appsync.NewResolver(ctx, "Mutation_pipelineTest", &appsync.ResolverArgs{
 * 			Type:             pulumi.String("Mutation"),
 * 			ApiId:            test.ID(),
 * 			Field:            pulumi.String("pipelineTest"),
 * 			RequestTemplate:  pulumi.String("{}"),
 * 			ResponseTemplate: pulumi.String("$util.toJson($ctx.result)"),
 * 			Kind:             pulumi.String("PIPELINE"),
 * 			PipelineConfig: &appsync.ResolverPipelineConfigArgs{
 * 				Functions: pulumi.StringArray{
 * 					test1.FunctionId,
 * 					test2.FunctionId,
 * 					test3.FunctionId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs;
 * import com.pulumi.aws.appsync.Resolver;
 * import com.pulumi.aws.appsync.ResolverArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverCachingConfigArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GraphQLApi("test", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("tf-example")
 *             .schema("""
 * type Mutation {
 * 	putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * 	id: ID!
 * 	title: String!
 * }
 * type Query {
 * 	singlePost(id: ID!): Post
 * }
 * schema {
 * 	query: Query
 * 	mutation: Mutation
 * }
 *             """)
 *             .build());
 *         var testDataSource = new DataSource("testDataSource", DataSourceArgs.builder()
 *             .apiId(test.id())
 *             .name("my_example")
 *             .type("HTTP")
 *             .httpConfig(DataSourceHttpConfigArgs.builder()
 *                 .endpoint("http://example.com")
 *                 .build())
 *             .build());
 *         // UNIT type resolver (default)
 *         var testResolver = new Resolver("testResolver", ResolverArgs.builder()
 *             .apiId(test.id())
 *             .field("singlePost")
 *             .type("Query")
 *             .dataSource(testDataSource.name())
 *             .requestTemplate("""
 * {
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 *             """)
 *             .responseTemplate("""
 * #if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 *             """)
 *             .cachingConfig(ResolverCachingConfigArgs.builder()
 *                 .cachingKeys(
 *                     "$context.identity.sub",
 *                     "$context.arguments.id")
 *                 .ttl(60)
 *                 .build())
 *             .build());
 *         // PIPELINE type resolver
 *         var mutationPipelineTest = new Resolver("mutationPipelineTest", ResolverArgs.builder()
 *             .type("Mutation")
 *             .apiId(test.id())
 *             .field("pipelineTest")
 *             .requestTemplate("{}")
 *             .responseTemplate("$util.toJson($ctx.result)")
 *             .kind("PIPELINE")
 *             .pipelineConfig(ResolverPipelineConfigArgs.builder()
 *                 .functions(
 *                     test1.functionId(),
 *                     test2.functionId(),
 *                     test3.functionId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: tf-example
 *       schema: |
 *         type Mutation {
 *         	putPost(id: ID!, title: String!): Post
 *         }
 *         type Post {
 *         	id: ID!
 *         	title: String!
 *         }
 *         type Query {
 *         	singlePost(id: ID!): Post
 *         }
 *         schema {
 *         	query: Query
 *         	mutation: Mutation
 *         }
 *   testDataSource:
 *     type: aws:appsync:DataSource
 *     name: test
 *     properties:
 *       apiId: ${test.id}
 *       name: my_example
 *       type: HTTP
 *       httpConfig:
 *         endpoint: http://example.com
 *   # UNIT type resolver (default)
 *   testResolver:
 *     type: aws:appsync:Resolver
 *     name: test
 *     properties:
 *       apiId: ${test.id}
 *       field: singlePost
 *       type: Query
 *       dataSource: ${testDataSource.name}
 *       requestTemplate: |
 *         {
 *             "version": "2018-05-29",
 *             "method": "GET",
 *             "resourcePath": "/",
 *             "params":{
 *                 "headers": $utils.http.copyheaders($ctx.request.headers)
 *             }
 *         }
 *       responseTemplate: |
 *         #if($ctx.result.statusCode == 200)
 *             $ctx.result.body
 *         #else
 *             $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 *         #end
 *       cachingConfig:
 *         cachingKeys:
 *           - $context.identity.sub
 *           - $context.arguments.id
 *         ttl: 60
 *   # PIPELINE type resolver
 *   mutationPipelineTest:
 *     type: aws:appsync:Resolver
 *     name: Mutation_pipelineTest
 *     properties:
 *       type: Mutation
 *       apiId: ${test.id}
 *       field: pipelineTest
 *       requestTemplate: '{}'
 *       responseTemplate: $util.toJson($ctx.result)
 *       kind: PIPELINE
 *       pipelineConfig:
 *         functions:
 *           - ${test1.functionId}
 *           - ${test2.functionId}
 *           - ${test3.functionId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### JS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.appsync.Resolver("example", {
 *     type: "Query",
 *     apiId: testAwsAppsyncGraphqlApi.id,
 *     field: "pipelineTest",
 *     kind: "PIPELINE",
 *     code: std.file({
 *         input: "some-code-dir",
 *     }).then(invoke => invoke.result),
 *     runtime: {
 *         name: "APPSYNC_JS",
 *         runtimeVersion: "1.0.0",
 *     },
 *     pipelineConfig: {
 *         functions: [test&#46;functionId],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.appsync.Resolver("example",
 *     type="Query",
 *     api_id=test_aws_appsync_graphql_api["id"],
 *     field="pipelineTest",
 *     kind="PIPELINE",
 *     code=std.file(input="some-code-dir").result,
 *     runtime={
 *         "name": "APPSYNC_JS",
 *         "runtime_version": "1.0.0",
 *     },
 *     pipeline_config={
 *         "functions": [test["functionId"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.Resolver("example", new()
 *     {
 *         Type = "Query",
 *         ApiId = testAwsAppsyncGraphqlApi.Id,
 *         Field = "pipelineTest",
 *         Kind = "PIPELINE",
 *         Code = Std.File.Invoke(new()
 *         {
 *             Input = "some-code-dir",
 *         }).Apply(invoke => invoke.Result),
 *         Runtime = new Aws.AppSync.Inputs.ResolverRuntimeArgs
 *         {
 *             Name = "APPSYNC_JS",
 *             RuntimeVersion = "1.0.0",
 *         },
 *         PipelineConfig = new Aws.AppSync.Inputs.ResolverPipelineConfigArgs
 *         {
 *             Functions = new[]
 *             {
 *                 test.FunctionId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "some-code-dir",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewResolver(ctx, "example", &appsync.ResolverArgs{
 * 			Type:  pulumi.String("Query"),
 * 			ApiId: pulumi.Any(testAwsAppsyncGraphqlApi.Id),
 * 			Field: pulumi.String("pipelineTest"),
 * 			Kind:  pulumi.String("PIPELINE"),
 * 			Code:  pulumi.String(invokeFile.Result),
 * 			Runtime: &appsync.ResolverRuntimeArgs{
 * 				Name:           pulumi.String("APPSYNC_JS"),
 * 				RuntimeVersion: pulumi.String("1.0.0"),
 * 			},
 * 			PipelineConfig: &appsync.ResolverPipelineConfigArgs{
 * 				Functions: pulumi.StringArray{
 * 					test.FunctionId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.Resolver;
 * import com.pulumi.aws.appsync.ResolverArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverRuntimeArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resolver("example", ResolverArgs.builder()
 *             .type("Query")
 *             .apiId(testAwsAppsyncGraphqlApi.id())
 *             .field("pipelineTest")
 *             .kind("PIPELINE")
 *             .code(StdFunctions.file(FileArgs.builder()
 *                 .input("some-code-dir")
 *                 .build()).result())
 *             .runtime(ResolverRuntimeArgs.builder()
 *                 .name("APPSYNC_JS")
 *                 .runtimeVersion("1.0.0")
 *                 .build())
 *             .pipelineConfig(ResolverPipelineConfigArgs.builder()
 *                 .functions(test.functionId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:Resolver
 *     properties:
 *       type: Query
 *       apiId: ${testAwsAppsyncGraphqlApi.id}
 *       field: pipelineTest
 *       kind: PIPELINE
 *       code:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: some-code-dir
 *           Return: result
 *       runtime:
 *         name: APPSYNC_JS
 *         runtimeVersion: 1.0.0
 *       pipelineConfig:
 *         functions:
 *           - ${test.functionId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appsync_resolver` using the `api_id`, a hyphen, `type`, a hypen and `field`. For example:
 * ```sh
 * $ pulumi import aws:appsync/resolver:Resolver example abcdef123456-exampleType-exampleField
 * ```
 * @property apiId API ID for the GraphQL API.
 * @property cachingConfig The Caching Config. See Caching Config.
 * @property code The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
 * @property dataSource Data source name.
 * @property field Field name from the schema defined in the GraphQL API.
 * @property kind Resolver type. Valid values are `UNIT` and `PIPELINE`.
 * @property maxBatchSize Maximum batching size for a resolver. Valid values are between `0` and `2000`.
 * @property pipelineConfig The caching configuration for the resolver. See Pipeline Config.
 * @property requestTemplate Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
 * @property responseTemplate Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
 * @property runtime Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
 * @property syncConfig Describes a Sync configuration for a resolver. See Sync Config.
 * @property type Type name from the schema defined in the GraphQL API.
 */
public data class ResolverArgs(
    public val apiId: Output<String>? = null,
    public val cachingConfig: Output<ResolverCachingConfigArgs>? = null,
    public val code: Output<String>? = null,
    public val dataSource: Output<String>? = null,
    public val `field`: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val maxBatchSize: Output<Int>? = null,
    public val pipelineConfig: Output<ResolverPipelineConfigArgs>? = null,
    public val requestTemplate: Output<String>? = null,
    public val responseTemplate: Output<String>? = null,
    public val runtime: Output<ResolverRuntimeArgs>? = null,
    public val syncConfig: Output<ResolverSyncConfigArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.ResolverArgs> {
    override fun toJava(): com.pulumi.aws.appsync.ResolverArgs =
        com.pulumi.aws.appsync.ResolverArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .cachingConfig(cachingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .code(code?.applyValue({ args0 -> args0 }))
            .dataSource(dataSource?.applyValue({ args0 -> args0 }))
            .`field`(`field`?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .maxBatchSize(maxBatchSize?.applyValue({ args0 -> args0 }))
            .pipelineConfig(pipelineConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requestTemplate(requestTemplate?.applyValue({ args0 -> args0 }))
            .responseTemplate(responseTemplate?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .syncConfig(syncConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverArgs].
 */
@PulumiTagMarker
public class ResolverArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var cachingConfig: Output<ResolverCachingConfigArgs>? = null

    private var code: Output<String>? = null

    private var dataSource: Output<String>? = null

    private var `field`: Output<String>? = null

    private var kind: Output<String>? = null

    private var maxBatchSize: Output<Int>? = null

    private var pipelineConfig: Output<ResolverPipelineConfigArgs>? = null

    private var requestTemplate: Output<String>? = null

    private var responseTemplate: Output<String>? = null

    private var runtime: Output<ResolverRuntimeArgs>? = null

    private var syncConfig: Output<ResolverSyncConfigArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value API ID for the GraphQL API.
     */
    @JvmName("aethxprgbxbgjyrk")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The Caching Config. See Caching Config.
     */
    @JvmName("okjbynxbpayswgyn")
    public suspend fun cachingConfig(`value`: Output<ResolverCachingConfigArgs>) {
        this.cachingConfig = value
    }

    /**
     * @param value The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    @JvmName("veojgncdawmskjqr")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Data source name.
     */
    @JvmName("ggpnavcwckitpkxt")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value Field name from the schema defined in the GraphQL API.
     */
    @JvmName("esjkjqkyenlhflge")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value Resolver type. Valid values are `UNIT` and `PIPELINE`.
     */
    @JvmName("qtgmuiywuevvlvse")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    @JvmName("steeetrabjfpooyk")
    public suspend fun maxBatchSize(`value`: Output<Int>) {
        this.maxBatchSize = value
    }

    /**
     * @param value The caching configuration for the resolver. See Pipeline Config.
     */
    @JvmName("csjdgnsjvcnildfn")
    public suspend fun pipelineConfig(`value`: Output<ResolverPipelineConfigArgs>) {
        this.pipelineConfig = value
    }

    /**
     * @param value Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    @JvmName("xpalkxmnabwplfks")
    public suspend fun requestTemplate(`value`: Output<String>) {
        this.requestTemplate = value
    }

    /**
     * @param value Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    @JvmName("lvgfqyoxgvthawti")
    public suspend fun responseTemplate(`value`: Output<String>) {
        this.responseTemplate = value
    }

    /**
     * @param value Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("ftsiulaqwxprvgcx")
    public suspend fun runtime(`value`: Output<ResolverRuntimeArgs>) {
        this.runtime = value
    }

    /**
     * @param value Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("vhelvbbljpwlvunx")
    public suspend fun syncConfig(`value`: Output<ResolverSyncConfigArgs>) {
        this.syncConfig = value
    }

    /**
     * @param value Type name from the schema defined in the GraphQL API.
     */
    @JvmName("lrxtgklsxthvtbup")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value API ID for the GraphQL API.
     */
    @JvmName("royshlhghwckttji")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The Caching Config. See Caching Config.
     */
    @JvmName("nobqrgfrgyhdtkcg")
    public suspend fun cachingConfig(`value`: ResolverCachingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cachingConfig = mapped
    }

    /**
     * @param argument The Caching Config. See Caching Config.
     */
    @JvmName("egdmcijvyshtvpjl")
    public suspend fun cachingConfig(argument: suspend ResolverCachingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverCachingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cachingConfig = mapped
    }

    /**
     * @param value The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    @JvmName("ckrhgiovwksnxiuw")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Data source name.
     */
    @JvmName("tbtukmfovovfclqq")
    public suspend fun dataSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value Field name from the schema defined in the GraphQL API.
     */
    @JvmName("krsbbaqoyutmmxws")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value Resolver type. Valid values are `UNIT` and `PIPELINE`.
     */
    @JvmName("cayravjchkjqvtik")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    @JvmName("mfhhfsmukbxdmibg")
    public suspend fun maxBatchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBatchSize = mapped
    }

    /**
     * @param value The caching configuration for the resolver. See Pipeline Config.
     */
    @JvmName("abbconhybayaalpq")
    public suspend fun pipelineConfig(`value`: ResolverPipelineConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineConfig = mapped
    }

    /**
     * @param argument The caching configuration for the resolver. See Pipeline Config.
     */
    @JvmName("vfptsarxylanlevx")
    public suspend fun pipelineConfig(argument: suspend ResolverPipelineConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverPipelineConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pipelineConfig = mapped
    }

    /**
     * @param value Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    @JvmName("dxobqaiuyldunlec")
    public suspend fun requestTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTemplate = mapped
    }

    /**
     * @param value Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    @JvmName("tkbwifoumtlymues")
    public suspend fun responseTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTemplate = mapped
    }

    /**
     * @param value Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("ocvgawxoibhjbfxy")
    public suspend fun runtime(`value`: ResolverRuntimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param argument Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("pgdxsbxuhptvnmrd")
    public suspend fun runtime(argument: suspend ResolverRuntimeArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverRuntimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runtime = mapped
    }

    /**
     * @param value Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("agrpfekpuhooekwg")
    public suspend fun syncConfig(`value`: ResolverSyncConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncConfig = mapped
    }

    /**
     * @param argument Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("kuvgsrjnwlrtsgyp")
    public suspend fun syncConfig(argument: suspend ResolverSyncConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverSyncConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.syncConfig = mapped
    }

    /**
     * @param value Type name from the schema defined in the GraphQL API.
     */
    @JvmName("eueoieafnjnoncmy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ResolverArgs = ResolverArgs(
        apiId = apiId,
        cachingConfig = cachingConfig,
        code = code,
        dataSource = dataSource,
        `field` = `field`,
        kind = kind,
        maxBatchSize = maxBatchSize,
        pipelineConfig = pipelineConfig,
        requestTemplate = requestTemplate,
        responseTemplate = responseTemplate,
        runtime = runtime,
        syncConfig = syncConfig,
        type = type,
    )
}
