@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Type].
 */
@PulumiTagMarker
public class TypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TypeArgs = TypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TypeArgsBuilder.() -> Unit) {
        val builder = TypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Type {
        val builtJavaResource = com.pulumi.aws.appsync.Type(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Type(builtJavaResource)
    }
}

/**
 * Provides an AppSync Type.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "example",
 * });
 * const exampleType = new aws.appsync.Type("example", {
 *     apiId: example.id,
 *     format: "SDL",
 *     definition: `type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="example")
 * example_type = aws.appsync.Type("example",
 *     api_id=example.id,
 *     format="SDL",
 *     definition="""type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "example",
 *     });
 *     var exampleType = new Aws.AppSync.Type("example", new()
 *     {
 *         ApiId = example.Id,
 *         Format = "SDL",
 *         Definition = @"type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewType(ctx, "example", &appsync.TypeArgs{
 * 			ApiId:  example.ID(),
 * 			Format: pulumi.String("SDL"),
 * 			Definition: pulumi.String(`type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.Type;
 * import com.pulumi.aws.appsync.TypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GraphQLApi("example", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("example")
 *             .build());
 *         var exampleType = new Type("exampleType", TypeArgs.builder()
 *             .apiId(example.id())
 *             .format("SDL")
 *             .definition("""
 * type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: example
 *   exampleType:
 *     type: aws:appsync:Type
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       format: SDL
 *       definition: |
 *         type Mutation
 *         {
 *         putPost(id: ID!,title: String! ): Post
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Appsync Types using the `id`. For example:
 * ```sh
 * $ pulumi import aws:appsync/type:Type example api-id:format:name
 * ```
 */
public class Type internal constructor(
    override val javaResource: com.pulumi.aws.appsync.Type,
) : KotlinCustomResource(javaResource, TypeMapper) {
    /**
     * GraphQL API ID.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the type.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type definition.
     */
    public val definition: Output<String>
        get() = javaResource.definition().applyValue({ args0 -> args0 })

    /**
     * The type description.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The type format: `SDL` or `JSON`.
     */
    public val format: Output<String>
        get() = javaResource.format().applyValue({ args0 -> args0 })

    /**
     * The type name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object TypeMapper : ResourceMapper<Type> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.Type::class == javaResource::class

    override fun map(javaResource: Resource): Type = Type(javaResource as com.pulumi.aws.appsync.Type)
}

/**
 * @see [Type].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Type].
 */
public suspend fun type(name: String, block: suspend TypeResourceBuilder.() -> Unit): Type {
    val builder = TypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Type].
 * @param name The _unique_ name of the resulting resource.
 */
public fun type(name: String): Type {
    val builder = TypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
