@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.TypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Type.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appsync.GraphQLApi("example", {
 *     authenticationType: "API_KEY",
 *     name: "example",
 * });
 * const exampleType = new aws.appsync.Type("example", {
 *     apiId: example.id,
 *     format: "SDL",
 *     definition: `type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appsync.GraphQLApi("example",
 *     authentication_type="API_KEY",
 *     name="example")
 * example_type = aws.appsync.Type("example",
 *     api_id=example.id,
 *     format="SDL",
 *     definition="""type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppSync.GraphQLApi("example", new()
 *     {
 *         AuthenticationType = "API_KEY",
 *         Name = "example",
 *     });
 *     var exampleType = new Aws.AppSync.Type("example", new()
 *     {
 *         ApiId = example.Id,
 *         Format = "SDL",
 *         Definition = @"type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appsync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := appsync.NewGraphQLApi(ctx, "example", &appsync.GraphQLApiArgs{
 * 			AuthenticationType: pulumi.String("API_KEY"),
 * 			Name:               pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appsync.NewType(ctx, "example", &appsync.TypeArgs{
 * 			ApiId:  example.ID(),
 * 			Format: pulumi.String("SDL"),
 * 			Definition: pulumi.String(`type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.Type;
 * import com.pulumi.aws.appsync.TypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GraphQLApi("example", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .name("example")
 *             .build());
 *         var exampleType = new Type("exampleType", TypeArgs.builder()
 *             .apiId(example.id())
 *             .format("SDL")
 *             .definition("""
 * type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appsync:GraphQLApi
 *     properties:
 *       authenticationType: API_KEY
 *       name: example
 *   exampleType:
 *     type: aws:appsync:Type
 *     name: example
 *     properties:
 *       apiId: ${example.id}
 *       format: SDL
 *       definition: |
 *         type Mutation
 *         {
 *         putPost(id: ID!,title: String! ): Post
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Appsync Types using the `id`. For example:
 * ```sh
 * $ pulumi import aws:appsync/type:Type example api-id:format:name
 * ```
 * @property apiId GraphQL API ID.
 * @property definition The type definition.
 * @property format The type format: `SDL` or `JSON`.
 */
public data class TypeArgs(
    public val apiId: Output<String>? = null,
    public val definition: Output<String>? = null,
    public val format: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.TypeArgs> {
    override fun toJava(): com.pulumi.aws.appsync.TypeArgs = com.pulumi.aws.appsync.TypeArgs.builder()
        .apiId(apiId?.applyValue({ args0 -> args0 }))
        .definition(definition?.applyValue({ args0 -> args0 }))
        .format(format?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TypeArgs].
 */
@PulumiTagMarker
public class TypeArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var definition: Output<String>? = null

    private var format: Output<String>? = null

    /**
     * @param value GraphQL API ID.
     */
    @JvmName("rwdbmhxclotayksx")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The type definition.
     */
    @JvmName("ptowlfmvictbpjme")
    public suspend fun definition(`value`: Output<String>) {
        this.definition = value
    }

    /**
     * @param value The type format: `SDL` or `JSON`.
     */
    @JvmName("njilutrstsmtlmsk")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value GraphQL API ID.
     */
    @JvmName("nwjohvilvqeelnyu")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The type definition.
     */
    @JvmName("pbetpevmxshfomdc")
    public suspend fun definition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value The type format: `SDL` or `JSON`.
     */
    @JvmName("girfykwqmcterccn")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    internal fun build(): TypeArgs = TypeArgs(
        apiId = apiId,
        definition = definition,
        format = format,
    )
}
