@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property signingRegion Signing Amazon Web Services Region for IAM authorization.
 * @property signingServiceName Signing service name for IAM authorization.
 */
public data class DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs(
    public val signingRegion: Output<String>? = null,
    public val signingServiceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs.builder()
            .signingRegion(signingRegion?.applyValue({ args0 -> args0 }))
            .signingServiceName(signingServiceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs].
 */
@PulumiTagMarker
public class DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgsBuilder internal constructor() {
    private var signingRegion: Output<String>? = null

    private var signingServiceName: Output<String>? = null

    /**
     * @param value Signing Amazon Web Services Region for IAM authorization.
     */
    @JvmName("xxxinklmmpohaulf")
    public suspend fun signingRegion(`value`: Output<String>) {
        this.signingRegion = value
    }

    /**
     * @param value Signing service name for IAM authorization.
     */
    @JvmName("bktiihuibfgbpjiq")
    public suspend fun signingServiceName(`value`: Output<String>) {
        this.signingServiceName = value
    }

    /**
     * @param value Signing Amazon Web Services Region for IAM authorization.
     */
    @JvmName("sgammrgykkdfofdo")
    public suspend fun signingRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingRegion = mapped
    }

    /**
     * @param value Signing service name for IAM authorization.
     */
    @JvmName("ohciufcxxxaabudq")
    public suspend fun signingServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingServiceName = mapped
    }

    internal fun build(): DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs =
        DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs(
            signingRegion = signingRegion,
            signingServiceName = signingServiceName,
        )
}
