@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceOpensearchserviceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpoint HTTP endpoint of the OpenSearch domain.
 * @property region AWS region of the OpenSearch domain. Defaults to current region.
 */
public data class DataSourceOpensearchserviceConfigArgs(
    public val endpoint: Output<String>,
    public val region: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceOpensearchserviceConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceOpensearchserviceConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceOpensearchserviceConfigArgs.builder()
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceOpensearchserviceConfigArgs].
 */
@PulumiTagMarker
public class DataSourceOpensearchserviceConfigArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var region: Output<String>? = null

    /**
     * @param value HTTP endpoint of the OpenSearch domain.
     */
    @JvmName("laqehwbvaqjancre")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value AWS region of the OpenSearch domain. Defaults to current region.
     */
    @JvmName("dbvuratawgbobmfq")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value HTTP endpoint of the OpenSearch domain.
     */
    @JvmName("snmkvmsctpmrfqmd")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value AWS region of the OpenSearch domain. Defaults to current region.
     */
    @JvmName("owfgvybdyxuhxypp")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): DataSourceOpensearchserviceConfigArgs =
        DataSourceOpensearchserviceConfigArgs(
            endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
            region = region,
        )
}
