@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.FunctionRuntimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
 * @property runtimeVersion The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
 */
public data class FunctionRuntimeArgs(
    public val name: Output<String>,
    public val runtimeVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.FunctionRuntimeArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.FunctionRuntimeArgs =
        com.pulumi.aws.appsync.inputs.FunctionRuntimeArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionRuntimeArgs].
 */
@PulumiTagMarker
public class FunctionRuntimeArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    /**
     * @param value The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
     */
    @JvmName("iyealdxeusyslaog")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
     */
    @JvmName("bpjohidaduywaxhv")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
     */
    @JvmName("dffklvobosncylvi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
     */
    @JvmName("oxphutpfaidgvheq")
    public suspend fun runtimeVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    internal fun build(): FunctionRuntimeArgs = FunctionRuntimeArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        runtimeVersion = runtimeVersion ?: throw PulumiNullFieldException("runtimeVersion"),
    )
}
