@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.FunctionSyncConfigLambdaConflictHandlerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lambdaConflictHandlerArn ARN for the Lambda function to use as the Conflict Handler.
 */
public data class FunctionSyncConfigLambdaConflictHandlerConfigArgs(
    public val lambdaConflictHandlerArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appsync.inputs.FunctionSyncConfigLambdaConflictHandlerConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.FunctionSyncConfigLambdaConflictHandlerConfigArgs =
        com.pulumi.aws.appsync.inputs.FunctionSyncConfigLambdaConflictHandlerConfigArgs.builder()
            .lambdaConflictHandlerArn(lambdaConflictHandlerArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionSyncConfigLambdaConflictHandlerConfigArgs].
 */
@PulumiTagMarker
public class FunctionSyncConfigLambdaConflictHandlerConfigArgsBuilder internal constructor() {
    private var lambdaConflictHandlerArn: Output<String>? = null

    /**
     * @param value ARN for the Lambda function to use as the Conflict Handler.
     */
    @JvmName("qxixdeauowriiqqw")
    public suspend fun lambdaConflictHandlerArn(`value`: Output<String>) {
        this.lambdaConflictHandlerArn = value
    }

    /**
     * @param value ARN for the Lambda function to use as the Conflict Handler.
     */
    @JvmName("kcniihcnbkrccfyg")
    public suspend fun lambdaConflictHandlerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaConflictHandlerArn = mapped
    }

    internal fun build(): FunctionSyncConfigLambdaConflictHandlerConfigArgs =
        FunctionSyncConfigLambdaConflictHandlerConfigArgs(
            lambdaConflictHandlerArn = lambdaConflictHandlerArn,
        )
}
