@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appIdClientRegex Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
 * @property awsRegion AWS region in which the user pool was created.
 * @property userPoolId User pool ID.
 */
public data class GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs(
    public val appIdClientRegex: Output<String>? = null,
    public val awsRegion: Output<String>? = null,
    public val userPoolId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs =
        com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs.builder()
            .appIdClientRegex(appIdClientRegex?.applyValue({ args0 -> args0 }))
            .awsRegion(awsRegion?.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs].
 */
@PulumiTagMarker
public class GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgsBuilder internal constructor() {
    private var appIdClientRegex: Output<String>? = null

    private var awsRegion: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
     */
    @JvmName("vhncukihxkqucgrp")
    public suspend fun appIdClientRegex(`value`: Output<String>) {
        this.appIdClientRegex = value
    }

    /**
     * @param value AWS region in which the user pool was created.
     */
    @JvmName("fvnfayiqvpmoadiw")
    public suspend fun awsRegion(`value`: Output<String>) {
        this.awsRegion = value
    }

    /**
     * @param value User pool ID.
     */
    @JvmName("djanxondpmyaxllo")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
     */
    @JvmName("voullsqceppxkhsm")
    public suspend fun appIdClientRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appIdClientRegex = mapped
    }

    /**
     * @param value AWS region in which the user pool was created.
     */
    @JvmName("dpobcuccereoxima")
    public suspend fun awsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsRegion = mapped
    }

    /**
     * @param value User pool ID.
     */
    @JvmName("sdsihfyanxpvflrf")
    public suspend fun userPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs =
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs(
            appIdClientRegex = appIdClientRegex,
            awsRegion = awsRegion,
            userPoolId = userPoolId ?: throw PulumiNullFieldException("userPoolId"),
        )
}
