@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.GraphQLApiEnhancedMetricsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataSourceLevelMetricsBehavior How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
 * @property operationLevelMetricsConfig How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
 * @property resolverLevelMetricsBehavior How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
 */
public data class GraphQLApiEnhancedMetricsConfigArgs(
    public val dataSourceLevelMetricsBehavior: Output<String>,
    public val operationLevelMetricsConfig: Output<String>,
    public val resolverLevelMetricsBehavior: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.GraphQLApiEnhancedMetricsConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.GraphQLApiEnhancedMetricsConfigArgs =
        com.pulumi.aws.appsync.inputs.GraphQLApiEnhancedMetricsConfigArgs.builder()
            .dataSourceLevelMetricsBehavior(dataSourceLevelMetricsBehavior.applyValue({ args0 -> args0 }))
            .operationLevelMetricsConfig(operationLevelMetricsConfig.applyValue({ args0 -> args0 }))
            .resolverLevelMetricsBehavior(resolverLevelMetricsBehavior.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiEnhancedMetricsConfigArgs].
 */
@PulumiTagMarker
public class GraphQLApiEnhancedMetricsConfigArgsBuilder internal constructor() {
    private var dataSourceLevelMetricsBehavior: Output<String>? = null

    private var operationLevelMetricsConfig: Output<String>? = null

    private var resolverLevelMetricsBehavior: Output<String>? = null

    /**
     * @param value How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
     */
    @JvmName("mavasakppmolskgv")
    public suspend fun dataSourceLevelMetricsBehavior(`value`: Output<String>) {
        this.dataSourceLevelMetricsBehavior = value
    }

    /**
     * @param value How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
     */
    @JvmName("mmgdcursbymwktvs")
    public suspend fun operationLevelMetricsConfig(`value`: Output<String>) {
        this.operationLevelMetricsConfig = value
    }

    /**
     * @param value How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
     */
    @JvmName("hnqolxqyxpgoxreb")
    public suspend fun resolverLevelMetricsBehavior(`value`: Output<String>) {
        this.resolverLevelMetricsBehavior = value
    }

    /**
     * @param value How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
     */
    @JvmName("ofxnbiabvengyvla")
    public suspend fun dataSourceLevelMetricsBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSourceLevelMetricsBehavior = mapped
    }

    /**
     * @param value How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
     */
    @JvmName("xvyejmsifvolpuun")
    public suspend fun operationLevelMetricsConfig(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationLevelMetricsConfig = mapped
    }

    /**
     * @param value How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
     */
    @JvmName("qakxljoohdouuxhr")
    public suspend fun resolverLevelMetricsBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resolverLevelMetricsBehavior = mapped
    }

    internal fun build(): GraphQLApiEnhancedMetricsConfigArgs = GraphQLApiEnhancedMetricsConfigArgs(
        dataSourceLevelMetricsBehavior = dataSourceLevelMetricsBehavior ?: throw
            PulumiNullFieldException("dataSourceLevelMetricsBehavior"),
        operationLevelMetricsConfig = operationLevelMetricsConfig ?: throw
            PulumiNullFieldException("operationLevelMetricsConfig"),
        resolverLevelMetricsBehavior = resolverLevelMetricsBehavior ?: throw
            PulumiNullFieldException("resolverLevelMetricsBehavior"),
    )
}
