@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.GraphQLApiOpenidConnectConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authTtl Number of milliseconds a token is valid after being authenticated.
 * @property clientId Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
 * @property iatTtl Number of milliseconds a token is valid after being issued to a user.
 * @property issuer Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
 */
public data class GraphQLApiOpenidConnectConfigArgs(
    public val authTtl: Output<Int>? = null,
    public val clientId: Output<String>? = null,
    public val iatTtl: Output<Int>? = null,
    public val issuer: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.GraphQLApiOpenidConnectConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.GraphQLApiOpenidConnectConfigArgs =
        com.pulumi.aws.appsync.inputs.GraphQLApiOpenidConnectConfigArgs.builder()
            .authTtl(authTtl?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .iatTtl(iatTtl?.applyValue({ args0 -> args0 }))
            .issuer(issuer.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiOpenidConnectConfigArgs].
 */
@PulumiTagMarker
public class GraphQLApiOpenidConnectConfigArgsBuilder internal constructor() {
    private var authTtl: Output<Int>? = null

    private var clientId: Output<String>? = null

    private var iatTtl: Output<Int>? = null

    private var issuer: Output<String>? = null

    /**
     * @param value Number of milliseconds a token is valid after being authenticated.
     */
    @JvmName("dqugmbqvuwqpxgox")
    public suspend fun authTtl(`value`: Output<Int>) {
        this.authTtl = value
    }

    /**
     * @param value Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
     */
    @JvmName("gfwelknxrugrdccg")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Number of milliseconds a token is valid after being issued to a user.
     */
    @JvmName("myjjbxugnswynapb")
    public suspend fun iatTtl(`value`: Output<Int>) {
        this.iatTtl = value
    }

    /**
     * @param value Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
     */
    @JvmName("jqgwnamyeuhxepjb")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value Number of milliseconds a token is valid after being authenticated.
     */
    @JvmName("qkubfjicejfagjta")
    public suspend fun authTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authTtl = mapped
    }

    /**
     * @param value Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
     */
    @JvmName("wgxcfhlodwxjtxbb")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Number of milliseconds a token is valid after being issued to a user.
     */
    @JvmName("kkgplmrapcpthctc")
    public suspend fun iatTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iatTtl = mapped
    }

    /**
     * @param value Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
     */
    @JvmName("hlaohfqjilcsmymo")
    public suspend fun issuer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    internal fun build(): GraphQLApiOpenidConnectConfigArgs = GraphQLApiOpenidConnectConfigArgs(
        authTtl = authTtl,
        clientId = clientId,
        iatTtl = iatTtl,
        issuer = issuer ?: throw PulumiNullFieldException("issuer"),
    )
}
