@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.GraphQLApiUserPoolConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appIdClientRegex Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
 * @property awsRegion AWS region in which the user pool was created.
 * @property defaultAction Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
 * @property userPoolId User pool ID.
 */
public data class GraphQLApiUserPoolConfigArgs(
    public val appIdClientRegex: Output<String>? = null,
    public val awsRegion: Output<String>? = null,
    public val defaultAction: Output<String>,
    public val userPoolId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.GraphQLApiUserPoolConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.GraphQLApiUserPoolConfigArgs =
        com.pulumi.aws.appsync.inputs.GraphQLApiUserPoolConfigArgs.builder()
            .appIdClientRegex(appIdClientRegex?.applyValue({ args0 -> args0 }))
            .awsRegion(awsRegion?.applyValue({ args0 -> args0 }))
            .defaultAction(defaultAction.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiUserPoolConfigArgs].
 */
@PulumiTagMarker
public class GraphQLApiUserPoolConfigArgsBuilder internal constructor() {
    private var appIdClientRegex: Output<String>? = null

    private var awsRegion: Output<String>? = null

    private var defaultAction: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
     */
    @JvmName("jwjqhqaysjornvgn")
    public suspend fun appIdClientRegex(`value`: Output<String>) {
        this.appIdClientRegex = value
    }

    /**
     * @param value AWS region in which the user pool was created.
     */
    @JvmName("kaiahixrcsvgwjbl")
    public suspend fun awsRegion(`value`: Output<String>) {
        this.awsRegion = value
    }

    /**
     * @param value Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
     */
    @JvmName("wiyfjkobwxgojgjb")
    public suspend fun defaultAction(`value`: Output<String>) {
        this.defaultAction = value
    }

    /**
     * @param value User pool ID.
     */
    @JvmName("lukyucaweuoyapnd")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
     */
    @JvmName("irgcxnedidespadj")
    public suspend fun appIdClientRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appIdClientRegex = mapped
    }

    /**
     * @param value AWS region in which the user pool was created.
     */
    @JvmName("syhbhsttwghjjvqf")
    public suspend fun awsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsRegion = mapped
    }

    /**
     * @param value Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
     */
    @JvmName("bbdsecmfghyppheo")
    public suspend fun defaultAction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value User pool ID.
     */
    @JvmName("qlxnoxioxactbcuu")
    public suspend fun userPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): GraphQLApiUserPoolConfigArgs = GraphQLApiUserPoolConfigArgs(
        appIdClientRegex = appIdClientRegex,
        awsRegion = awsRegion,
        defaultAction = defaultAction ?: throw PulumiNullFieldException("defaultAction"),
        userPoolId = userPoolId ?: throw PulumiNullFieldException("userPoolId"),
    )
}
