@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.ResolverCachingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cachingKeys The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
 * @property ttl The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
 */
public data class ResolverCachingConfigArgs(
    public val cachingKeys: Output<List<String>>? = null,
    public val ttl: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.ResolverCachingConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.ResolverCachingConfigArgs =
        com.pulumi.aws.appsync.inputs.ResolverCachingConfigArgs.builder()
            .cachingKeys(cachingKeys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverCachingConfigArgs].
 */
@PulumiTagMarker
public class ResolverCachingConfigArgsBuilder internal constructor() {
    private var cachingKeys: Output<List<String>>? = null

    private var ttl: Output<Int>? = null

    /**
     * @param value The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
     */
    @JvmName("fdrdydliwyalmpdu")
    public suspend fun cachingKeys(`value`: Output<List<String>>) {
        this.cachingKeys = value
    }

    @JvmName("blvvjhdkbasuttql")
    public suspend fun cachingKeys(vararg values: Output<String>) {
        this.cachingKeys = Output.all(values.asList())
    }

    /**
     * @param values The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
     */
    @JvmName("kxyeumdvvuvhlwve")
    public suspend fun cachingKeys(values: List<Output<String>>) {
        this.cachingKeys = Output.all(values)
    }

    /**
     * @param value The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
     */
    @JvmName("hlobqcxyjufrpnvg")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
     */
    @JvmName("qekmbuvlbakmjxku")
    public suspend fun cachingKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cachingKeys = mapped
    }

    /**
     * @param values The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
     */
    @JvmName("lsusvjyqohaihwui")
    public suspend fun cachingKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cachingKeys = mapped
    }

    /**
     * @param value The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
     */
    @JvmName("smovuytuaeagfkoe")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): ResolverCachingConfigArgs = ResolverCachingConfigArgs(
        cachingKeys = cachingKeys,
        ttl = ttl,
    )
}
