@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property functions A list of Function objects.
 */
public data class ResolverPipelineConfigArgs(
    public val functions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs =
        com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs.builder()
            .functions(functions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResolverPipelineConfigArgs].
 */
@PulumiTagMarker
public class ResolverPipelineConfigArgsBuilder internal constructor() {
    private var functions: Output<List<String>>? = null

    /**
     * @param value A list of Function objects.
     */
    @JvmName("ladrlrxbbjfsgbdw")
    public suspend fun functions(`value`: Output<List<String>>) {
        this.functions = value
    }

    @JvmName("lhdhjsonnkiquwui")
    public suspend fun functions(vararg values: Output<String>) {
        this.functions = Output.all(values.asList())
    }

    /**
     * @param values A list of Function objects.
     */
    @JvmName("cevymanbokupgbkp")
    public suspend fun functions(values: List<Output<String>>) {
        this.functions = Output.all(values)
    }

    /**
     * @param value A list of Function objects.
     */
    @JvmName("xlgudonbqfmmmdhw")
    public suspend fun functions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functions = mapped
    }

    /**
     * @param values A list of Function objects.
     */
    @JvmName("yupplmartqbjmjno")
    public suspend fun functions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functions = mapped
    }

    internal fun build(): ResolverPipelineConfigArgs = ResolverPipelineConfigArgs(
        functions = functions,
    )
}
