@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.ResolverSyncConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property conflictDetection Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
 * @property conflictHandler Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
 * @property lambdaConflictHandlerConfig Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
 */
public data class ResolverSyncConfigArgs(
    public val conflictDetection: Output<String>? = null,
    public val conflictHandler: Output<String>? = null,
    public val lambdaConflictHandlerConfig: Output<ResolverSyncConfigLambdaConflictHandlerConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.ResolverSyncConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.ResolverSyncConfigArgs =
        com.pulumi.aws.appsync.inputs.ResolverSyncConfigArgs.builder()
            .conflictDetection(conflictDetection?.applyValue({ args0 -> args0 }))
            .conflictHandler(conflictHandler?.applyValue({ args0 -> args0 }))
            .lambdaConflictHandlerConfig(
                lambdaConflictHandlerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ResolverSyncConfigArgs].
 */
@PulumiTagMarker
public class ResolverSyncConfigArgsBuilder internal constructor() {
    private var conflictDetection: Output<String>? = null

    private var conflictHandler: Output<String>? = null

    private var lambdaConflictHandlerConfig:
        Output<ResolverSyncConfigLambdaConflictHandlerConfigArgs>? = null

    /**
     * @param value Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
     */
    @JvmName("hjkesqriuaasylaf")
    public suspend fun conflictDetection(`value`: Output<String>) {
        this.conflictDetection = value
    }

    /**
     * @param value Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
     */
    @JvmName("eotypddoawjuwcpy")
    public suspend fun conflictHandler(`value`: Output<String>) {
        this.conflictHandler = value
    }

    /**
     * @param value Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
     */
    @JvmName("ipruueluyxvxltsq")
    public suspend fun lambdaConflictHandlerConfig(`value`: Output<ResolverSyncConfigLambdaConflictHandlerConfigArgs>) {
        this.lambdaConflictHandlerConfig = value
    }

    /**
     * @param value Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
     */
    @JvmName("yhjjlrpvyvfaudoh")
    public suspend fun conflictDetection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictDetection = mapped
    }

    /**
     * @param value Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
     */
    @JvmName("shbgkmcaxsjwfnqu")
    public suspend fun conflictHandler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictHandler = mapped
    }

    /**
     * @param value Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
     */
    @JvmName("xfivedtksnxdktqa")
    public suspend fun lambdaConflictHandlerConfig(`value`: ResolverSyncConfigLambdaConflictHandlerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaConflictHandlerConfig = mapped
    }

    /**
     * @param argument Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
     */
    @JvmName("gncngfcymhvdrpph")
    public suspend fun lambdaConflictHandlerConfig(argument: suspend ResolverSyncConfigLambdaConflictHandlerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverSyncConfigLambdaConflictHandlerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lambdaConflictHandlerConfig = mapped
    }

    internal fun build(): ResolverSyncConfigArgs = ResolverSyncConfigArgs(
        conflictDetection = conflictDetection,
        conflictHandler = conflictHandler,
        lambdaConflictHandlerConfig = lambdaConflictHandlerConfig,
    )
}
