@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.ResolverSyncConfigLambdaConflictHandlerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lambdaConflictHandlerArn ARN for the Lambda function to use as the Conflict Handler.
 */
public data class ResolverSyncConfigLambdaConflictHandlerConfigArgs(
    public val lambdaConflictHandlerArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appsync.inputs.ResolverSyncConfigLambdaConflictHandlerConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.ResolverSyncConfigLambdaConflictHandlerConfigArgs =
        com.pulumi.aws.appsync.inputs.ResolverSyncConfigLambdaConflictHandlerConfigArgs.builder()
            .lambdaConflictHandlerArn(lambdaConflictHandlerArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverSyncConfigLambdaConflictHandlerConfigArgs].
 */
@PulumiTagMarker
public class ResolverSyncConfigLambdaConflictHandlerConfigArgsBuilder internal constructor() {
    private var lambdaConflictHandlerArn: Output<String>? = null

    /**
     * @param value ARN for the Lambda function to use as the Conflict Handler.
     */
    @JvmName("fysbntyhpknmmdfx")
    public suspend fun lambdaConflictHandlerArn(`value`: Output<String>) {
        this.lambdaConflictHandlerArn = value
    }

    /**
     * @param value ARN for the Lambda function to use as the Conflict Handler.
     */
    @JvmName("xdnsxxxiffqhwlwg")
    public suspend fun lambdaConflictHandlerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaConflictHandlerArn = mapped
    }

    internal fun build(): ResolverSyncConfigLambdaConflictHandlerConfigArgs =
        ResolverSyncConfigLambdaConflictHandlerConfigArgs(
            lambdaConflictHandlerArn = lambdaConflictHandlerArn,
        )
}
