@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deltaSyncConfig The DeltaSyncConfig for a versioned data source. See `delta_sync_config` Block for details.
 * @property region AWS region of the DynamoDB table. Defaults to current region.
 * @property tableName Name of the DynamoDB table.
 * @property useCallerCredentials Set to `true` to use Amazon Cognito credentials with this data source.
 * @property versioned Detects Conflict Detection and Resolution with this data source.
 */
public data class DataSourceDynamodbConfig(
    public val deltaSyncConfig: DataSourceDynamodbConfigDeltaSyncConfig? = null,
    public val region: String? = null,
    public val tableName: String,
    public val useCallerCredentials: Boolean? = null,
    public val versioned: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.DataSourceDynamodbConfig): DataSourceDynamodbConfig = DataSourceDynamodbConfig(
            deltaSyncConfig = javaType.deltaSyncConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appsync.kotlin.outputs.DataSourceDynamodbConfigDeltaSyncConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            tableName = javaType.tableName(),
            useCallerCredentials = javaType.useCallerCredentials().map({ args0 -> args0 }).orElse(null),
            versioned = javaType.versioned().map({ args0 -> args0 }).orElse(null),
        )
    }
}
