@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property baseTableTtl The number of minutes that an Item is stored in the data source.
 * @property deltaSyncTableName The table name.
 * @property deltaSyncTableTtl The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
 */
public data class DataSourceDynamodbConfigDeltaSyncConfig(
    public val baseTableTtl: Int? = null,
    public val deltaSyncTableName: String,
    public val deltaSyncTableTtl: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.DataSourceDynamodbConfigDeltaSyncConfig): DataSourceDynamodbConfigDeltaSyncConfig = DataSourceDynamodbConfigDeltaSyncConfig(
            baseTableTtl = javaType.baseTableTtl().map({ args0 -> args0 }).orElse(null),
            deltaSyncTableName = javaType.deltaSyncTableName(),
            deltaSyncTableTtl = javaType.deltaSyncTableTtl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
