@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationConfig Authorization configuration in case the HTTP endpoint requires authorization. See `authorization_config` Block for details.
 * @property endpoint HTTP URL.
 */
public data class DataSourceHttpConfig(
    public val authorizationConfig: DataSourceHttpConfigAuthorizationConfig? = null,
    public val endpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.DataSourceHttpConfig): DataSourceHttpConfig = DataSourceHttpConfig(
            authorizationConfig = javaType.authorizationConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appsync.kotlin.outputs.DataSourceHttpConfigAuthorizationConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoint = javaType.endpoint(),
        )
    }
}
