@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpoint HTTP endpoint of the OpenSearch domain.
 * @property region AWS region of the OpenSearch domain. Defaults to current region.
 */
public data class DataSourceOpensearchserviceConfig(
    public val endpoint: String,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.DataSourceOpensearchserviceConfig): DataSourceOpensearchserviceConfig = DataSourceOpensearchserviceConfig(
            endpoint = javaType.endpoint(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
