@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpEndpointConfig Amazon RDS HTTP endpoint configuration. See `http_endpoint_config` Block for details.
 * @property sourceType Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
 */
public data class DataSourceRelationalDatabaseConfig(
    public val httpEndpointConfig: DataSourceRelationalDatabaseConfigHttpEndpointConfig? = null,
    public val sourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.DataSourceRelationalDatabaseConfig): DataSourceRelationalDatabaseConfig = DataSourceRelationalDatabaseConfig(
            httpEndpointConfig = javaType.httpEndpointConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appsync.kotlin.outputs.DataSourceRelationalDatabaseConfigHttpEndpointConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceType = javaType.sourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
