@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property awsSecretStoreArn AWS secret store ARN for database credentials.
 * @property databaseName Logical database name.
 * @property dbClusterIdentifier Amazon RDS cluster identifier.
 * @property region AWS Region for RDS HTTP endpoint. Defaults to current region.
 * @property schema Logical schema name.
 */
public data class DataSourceRelationalDatabaseConfigHttpEndpointConfig(
    public val awsSecretStoreArn: String,
    public val databaseName: String? = null,
    public val dbClusterIdentifier: String,
    public val region: String? = null,
    public val schema: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.DataSourceRelationalDatabaseConfigHttpEndpointConfig): DataSourceRelationalDatabaseConfigHttpEndpointConfig =
            DataSourceRelationalDatabaseConfigHttpEndpointConfig(
                awsSecretStoreArn = javaType.awsSecretStoreArn(),
                databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
                dbClusterIdentifier = javaType.dbClusterIdentifier(),
                region = javaType.region().map({ args0 -> args0 }).orElse(null),
                schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            )
    }
}
