@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
 * @property runtimeVersion The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
 */
public data class FunctionRuntime(
    public val name: String,
    public val runtimeVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.FunctionRuntime): FunctionRuntime =
            FunctionRuntime(
                name = javaType.name(),
                runtimeVersion = javaType.runtimeVersion(),
            )
    }
}
