@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizerResultTtlInSeconds Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
 * @property authorizerUri ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
 * @property identityValidationExpression Regular expression for validation of tokens before the Lambda function is called.
 */
public data class GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig(
    public val authorizerResultTtlInSeconds: Int? = null,
    public val authorizerUri: String,
    public val identityValidationExpression: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig): GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig =
            GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig(
                authorizerResultTtlInSeconds = javaType.authorizerResultTtlInSeconds().map({ args0 ->
                    args0
                }).orElse(null),
                authorizerUri = javaType.authorizerUri(),
                identityValidationExpression = javaType.identityValidationExpression().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
