@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authTtl Number of milliseconds a token is valid after being authenticated.
 * @property clientId Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
 * @property iatTtl Number of milliseconds a token is valid after being issued to a user.
 * @property issuer Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
 */
public data class GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig(
    public val authTtl: Int? = null,
    public val clientId: String? = null,
    public val iatTtl: Int? = null,
    public val issuer: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig): GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig =
            GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig(
                authTtl = javaType.authTtl().map({ args0 -> args0 }).orElse(null),
                clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
                iatTtl = javaType.iatTtl().map({ args0 -> args0 }).orElse(null),
                issuer = javaType.issuer(),
            )
    }
}
