@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataSourceLevelMetricsBehavior How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
 * @property operationLevelMetricsConfig How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
 * @property resolverLevelMetricsBehavior How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
 */
public data class GraphQLApiEnhancedMetricsConfig(
    public val dataSourceLevelMetricsBehavior: String,
    public val operationLevelMetricsConfig: String,
    public val resolverLevelMetricsBehavior: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.GraphQLApiEnhancedMetricsConfig): GraphQLApiEnhancedMetricsConfig = GraphQLApiEnhancedMetricsConfig(
            dataSourceLevelMetricsBehavior = javaType.dataSourceLevelMetricsBehavior(),
            operationLevelMetricsConfig = javaType.operationLevelMetricsConfig(),
            resolverLevelMetricsBehavior = javaType.resolverLevelMetricsBehavior(),
        )
    }
}
